/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os;

import io.camunda.optimize.dto.optimize.SimpleDefinitionDto;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.util.ExceptionUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.CompositeAggregate;
import org.opensearch.client.opensearch._types.aggregations.CompositeAggregation;
import org.opensearch.client.opensearch._types.aggregations.CompositeBucket;
import org.opensearch.client.opensearch._types.aggregations.NestedAggregation;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSearchCompositeAggregationScroller {
    private static final Logger LOG = LoggerFactory.getLogger(OpenSearchCompositeAggregationScroller.class);
    private OptimizeOpenSearchClient osClient;
    private SearchRequest.Builder searchRequestBuilder;
    private Consumer<CompositeBucket> compositeBucketConsumer;
    private LinkedList<String> pathToAggregation;
    private Query query;
    private int requestSize;
    private List<String> indices;
    private Map<String, Aggregation> aggregations;

    public OpenSearchCompositeAggregationScroller aggregations(Map<String, Aggregation> aggregations) {
        this.aggregations = new HashMap<String, Aggregation>(aggregations);
        return this;
    }

    public OpenSearchCompositeAggregationScroller query(Query query) {
        this.query = query;
        return this;
    }

    public OpenSearchCompositeAggregationScroller index(List<String> indices) {
        this.indices = indices;
        return this;
    }

    public OpenSearchCompositeAggregationScroller size(int size) {
        this.requestSize = size;
        return this;
    }

    public static OpenSearchCompositeAggregationScroller create() {
        return new OpenSearchCompositeAggregationScroller();
    }

    public void consumeAllPages() {
        boolean pageConsumed;
        while (pageConsumed = this.consumePage()) {
        }
    }

    public boolean consumePage() {
        List<CompositeBucket> currentPage = this.getNextPage();
        currentPage.forEach(this.compositeBucketConsumer);
        return !currentPage.isEmpty();
    }

    private List<CompositeBucket> getNextPage() {
        String errorMessage = String.format("Was not able to get next page of %s aggregation.", this.pathToAggregation.getLast());
        this.searchRequestBuilder = new SearchRequest.Builder().index(this.indices).query(this.query).aggregations(this.aggregations).size(Integer.valueOf(this.requestSize));
        try {
            SearchResponse searchResponse = this.osClient.search(this.searchRequestBuilder, SimpleDefinitionDto.class, errorMessage);
            CompositeAggregate compositeAggregationResult = this.extractCompositeAggregationResult(searchResponse);
            Map safeAfterKeyMap = compositeAggregationResult.afterKey().entrySet().stream().collect(HashMap::new, (m, v) -> m.put((String)v.getKey(), (String)((JsonData)v.getValue()).to(String.class)), HashMap::putAll);
            this.aggregations = this.updateAfterKeyInCompositeAggregation(safeAfterKeyMap, this.aggregations);
            return compositeAggregationResult.buckets().array();
        }
        catch (RuntimeException e) {
            if (ExceptionUtil.isInstanceIndexNotFoundException((RuntimeException)e)) {
                LOG.info("Was not able to get next page of {} aggregation because at least one instance from {} does not exist.", (Object)this.pathToAggregation.getLast(), this.indices);
                return Collections.emptyList();
            }
            throw e;
        }
    }

    private HashMap<String, Aggregation> updateAfterKeyInCompositeAggregation(Map<String, String> safeAfterKeyMap, Map<String, Aggregation> currentAgg) {
        return this.updateAfterKeyInCompositeAggregation(safeAfterKeyMap, currentAgg, false);
    }

    private HashMap<String, Aggregation> updateAfterKeyInCompositeAggregation(Map<String, String> safeAfterKeyMap, Map<String, Aggregation> currentAgg, boolean isFromNested) {
        HashMap<String, Aggregation> newAggregations = new HashMap<String, Aggregation>();
        if (safeAfterKeyMap.isEmpty()) {
            return new HashMap<String, Aggregation>(currentAgg);
        }
        for (String aggPath : this.pathToAggregation) {
            Aggregation agg = currentAgg.get(aggPath);
            if (agg == null) continue;
            if (agg.isNested()) {
                Aggregation newNestedAgg = new Aggregation.Builder().nested(new NestedAggregation.Builder().path(agg.nested().path()).build()).aggregations(this.updateAfterKeyInCompositeAggregation(safeAfterKeyMap, agg.aggregations(), true)).build();
                newAggregations.put(aggPath, newNestedAgg);
                continue;
            }
            if (!agg.isComposite()) continue;
            CompositeAggregation newAgg = this.updateCompositeAggregation(agg.composite(), safeAfterKeyMap);
            if (isFromNested) {
                newAggregations.put(aggPath, newAgg._toAggregation());
                continue;
            }
            Aggregation upgradeAgg = Aggregation.of(a -> {
                if (agg.aggregations() != null) {
                    a.aggregations(agg.aggregations());
                }
                return a.composite(newAgg);
            });
            newAggregations.put(aggPath, upgradeAgg);
        }
        return newAggregations;
    }

    private CompositeAggregation updateCompositeAggregation(CompositeAggregation prevCompositeAggregation, Map<String, String> safeAfterKeyMap) {
        return ((CompositeAggregation.Builder)((CompositeAggregation.Builder)new CompositeAggregation.Builder().sources(prevCompositeAggregation.sources()).size(prevCompositeAggregation.size()).name(prevCompositeAggregation.name())).meta(prevCompositeAggregation.meta())).after(safeAfterKeyMap).build();
    }

    private CompositeAggregate extractCompositeAggregationResult(SearchResponse searchResponse) {
        Map aggregations = searchResponse.aggregations();
        for (int i = 0; i < this.pathToAggregation.size() - 1; ++i) {
            Aggregate agg = (Aggregate)aggregations.get(this.pathToAggregation.get(i));
            if (!agg.isNested()) continue;
            aggregations = agg.nested().aggregations();
        }
        return ((Aggregate)aggregations.get(this.pathToAggregation.getLast())).composite();
    }

    public OpenSearchCompositeAggregationScroller setClient(OptimizeOpenSearchClient osClient) {
        this.osClient = osClient;
        return this;
    }

    public OpenSearchCompositeAggregationScroller setCompositeBucketConsumer(Consumer<CompositeBucket> compositeBucketConsumer) {
        this.compositeBucketConsumer = compositeBucketConsumer;
        return this;
    }

    public OpenSearchCompositeAggregationScroller setPathToAggregation(String ... pathToAggregation) {
        this.pathToAggregation = new LinkedList<String>(Arrays.asList(pathToAggregation));
        return this;
    }
}

