/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.helper;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.ImportRequestDto;
import io.camunda.optimize.dto.optimize.ProcessInstanceDto;
import io.camunda.optimize.dto.optimize.RequestType;
import io.camunda.optimize.service.db.schema.ScriptData;
import io.camunda.optimize.service.db.writer.DatabaseWriterUtil;
import io.camunda.optimize.service.util.InstanceIndexUtil;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class ImportRequestDtoFactory {
    final ObjectMapper objectMapper;

    public ImportRequestDtoFactory(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public ImportRequestDto createImportRequestForProcessInstance(ProcessInstanceDto processInstanceDto, Set<String> updatableFields, String importItemName) {
        ScriptData updateScript = DatabaseWriterUtil.createScriptData(updatableFields, processInstanceDto, this.objectMapper);
        return this.createUpsertRequestDtoForProcessInstance(processInstanceDto, updateScript, importItemName);
    }

    private ImportRequestDto createUpsertRequestDtoForProcessInstance(ProcessInstanceDto processInstanceDto, ScriptData updateScriptData, String importItemName) {
        return ImportRequestDto.builder().indexName(InstanceIndexUtil.getProcessInstanceIndexAliasName((String)processInstanceDto.getProcessDefinitionKey())).id(processInstanceDto.getProcessInstanceId()).scriptData(updateScriptData).importName(importItemName).source((Object)processInstanceDto).type(RequestType.UPDATE).retryNumberOnConflict(5).build();
    }
}

