/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.writer;

import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch.core.UpdateRequest;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.SettingsDto;
import io.camunda.optimize.rest.exceptions.BadRequestException;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeUpdateRequestBuilderES;
import io.camunda.optimize.service.db.es.writer.ElasticsearchWriterUtil;
import io.camunda.optimize.service.db.schema.index.SettingsIndex;
import io.camunda.optimize.service.db.writer.SettingsWriter;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.io.IOException;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class SettingsWriterES
implements SettingsWriter {
    private static final Logger LOG = LoggerFactory.getLogger(SettingsWriterES.class);
    private final OptimizeElasticsearchClient esClient;
    private final ObjectMapper objectMapper;

    public SettingsWriterES(OptimizeElasticsearchClient esClient, ObjectMapper objectMapper) {
        this.esClient = esClient;
        this.objectMapper = objectMapper;
    }

    @Override
    public void upsertSettings(SettingsDto settingsDto) {
        LOG.debug("Writing settings to ES");
        try {
            UpdateRequest<SettingsDto, SettingsDto> request = this.createSettingsUpsert(settingsDto);
            this.esClient.update(request, SettingsDto.class);
        }
        catch (IOException e) {
            String errorMessage = "There were errors while writing settings.";
            LOG.error("There were errors while writing settings.", (Throwable)e);
            throw new OptimizeRuntimeException("There were errors while writing settings.", (Throwable)e);
        }
    }

    private UpdateRequest<SettingsDto, SettingsDto> createSettingsUpsert(SettingsDto settingsDto) throws JsonProcessingException {
        HashSet<String> fieldsToUpdate = new HashSet<String>();
        if (settingsDto.getSharingEnabled().isPresent()) {
            fieldsToUpdate.add(SettingsIndex.SHARING_ENABLED);
        }
        if (fieldsToUpdate.isEmpty()) {
            throw new BadRequestException("No settings can be updated, as no values are present!");
        }
        fieldsToUpdate.add(SettingsIndex.LAST_MODIFIED);
        Script updateScript = ElasticsearchWriterUtil.createFieldUpdateScript(fieldsToUpdate, settingsDto, this.objectMapper);
        return new OptimizeUpdateRequestBuilderES().optimizeIndex(this.esClient, new String[]{"settings"}).id("1").upsert((Object)settingsDto).script(updateScript).refresh(Refresh.True).retryOnConflict(Integer.valueOf(5)).build();
    }
}

