/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.writer;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.ScriptLanguage;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import io.camunda.optimize.dto.optimize.ProcessDefinitionOptimizeDto;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeUpdateRequestBuilderES;
import io.camunda.optimize.service.db.es.writer.AbstractProcessDefinitionWriterES;
import io.camunda.optimize.service.db.es.writer.ElasticsearchWriterUtil;
import io.camunda.optimize.service.db.repository.es.TaskRepositoryES;
import io.camunda.optimize.service.db.writer.ProcessDefinitionWriter;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class ProcessDefinitionWriterES
extends AbstractProcessDefinitionWriterES
implements ProcessDefinitionWriter {
    private static final Script MARK_AS_DELETED_SCRIPT = Script.of(s -> s.inline(i -> i.lang(ScriptLanguage.Painless).source("ctx._source.deleted = true")));
    private static final Script MARK_AS_ONBOARDED_SCRIPT = Script.of(s -> s.inline(i -> i.lang(ScriptLanguage.Painless).source("ctx._source.onboarded = true")));
    private static final Logger LOG = LoggerFactory.getLogger(ProcessDefinitionWriterES.class);
    private final ConfigurationService configurationService;

    public ProcessDefinitionWriterES(OptimizeElasticsearchClient esClient, ObjectMapper objectMapper, ConfigurationService configurationService, TaskRepositoryES taskRepositoryES) {
        super(objectMapper, esClient, taskRepositoryES);
        this.configurationService = configurationService;
    }

    @Override
    public void importProcessDefinitions(List<ProcessDefinitionOptimizeDto> procDefs) {
        LOG.debug("Writing [{}] process definitions to elasticsearch", (Object)procDefs.size());
        this.writeProcessDefinitionInformation(procDefs);
    }

    @Override
    public void markDefinitionAsDeleted(String definitionId) {
        LOG.debug("Marking process definition with ID {} as deleted", (Object)definitionId);
        try {
            this.esClient.update(new OptimizeUpdateRequestBuilderES().optimizeIndex(this.esClient, new String[]{"process-definition"}).id(definitionId).script(MARK_AS_DELETED_SCRIPT).retryOnConflict(Integer.valueOf(5)).build(), Object.class);
        }
        catch (Exception e) {
            throw new OptimizeRuntimeException(String.format("There was a problem when trying to mark process definition with ID %s as deleted", definitionId), (Throwable)e);
        }
    }

    @Override
    public boolean markRedeployedDefinitionsAsDeleted(List<ProcessDefinitionOptimizeDto> importedDefinitions) {
        AtomicBoolean definitionsUpdated = new AtomicBoolean(false);
        Lists.partition(importedDefinitions, (int)1000).forEach(partition -> {
            BoolQuery.Builder definitionsToDeleteQueryBuilder = new BoolQuery.Builder();
            HashSet processDefIds = new HashSet();
            partition.forEach(definition -> {
                BoolQuery.Builder matchingDefinitionQuery = new BoolQuery.Builder().must(m -> m.term(t -> t.field("key").value(definition.getKey()))).must(m -> m.term(t -> t.field("version").value(definition.getVersion()))).mustNot(m -> m.term(t -> t.field("id").value(definition.getId())));
                processDefIds.add(definition.getId());
                if (definition.getTenantId() != null) {
                    matchingDefinitionQuery.must(m -> m.term(t -> t.field("tenantId").value(definition.getTenantId())));
                } else {
                    matchingDefinitionQuery.mustNot(m -> m.exists(t -> t.field("tenantId")));
                }
                definitionsToDeleteQueryBuilder.should(s -> s.bool(matchingDefinitionQuery.build()));
            });
            boolean deleted = this.taskRepositoryES.tryUpdateByQueryRequest(String.format("%d process definitions", processDefIds.size()), MARK_AS_DELETED_SCRIPT, Query.of(q -> q.bool(definitionsToDeleteQueryBuilder.build())), "process-definition");
            if (deleted && !definitionsUpdated.get()) {
                definitionsUpdated.set(true);
            }
        });
        if (definitionsUpdated.get()) {
            LOG.debug("Marked old process definitions with new deployments as deleted");
        }
        return definitionsUpdated.get();
    }

    @Override
    public void markDefinitionKeysAsOnboarded(Set<String> definitionKeys) {
        this.taskRepositoryES.tryUpdateByQueryRequest("process definitions onboarded state", MARK_AS_ONBOARDED_SCRIPT, Query.of(q -> q.bool(b -> b.must(m -> m.terms(t -> t.field("key").terms(tt -> tt.value(definitionKeys.stream().map(FieldValue::of).toList())))))), "process-definition");
    }

    @Override
    Script createUpdateScript(ProcessDefinitionOptimizeDto processDefinitionDto) {
        return ElasticsearchWriterUtil.createFieldUpdateScript(FIELDS_TO_UPDATE, processDefinitionDto, this.objectMapper);
    }

    private void writeProcessDefinitionInformation(List<ProcessDefinitionOptimizeDto> procDefs) {
        String importItemName = "process definition information";
        LOG.debug("Writing [{}] {} to ES.", (Object)procDefs.size(), (Object)"process definition information");
        this.esClient.doImportBulkRequestWithList("process definition information", procDefs, this::addImportProcessDefinitionToRequest, this.configurationService.getSkipDataAfterNestedDocLimitReached().booleanValue());
    }
}

