/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.writer;

import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.InlineScript;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.Result;
import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.ScriptLanguage;
import co.elastic.clients.elasticsearch._types.query_dsl.ChildScoreMode;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.DeleteResponse;
import co.elastic.clients.elasticsearch.core.IndexResponse;
import co.elastic.clients.elasticsearch.core.UpdateResponse;
import co.elastic.clients.json.JsonData;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.query.IdResponseDto;
import io.camunda.optimize.dto.optimize.query.dashboard.DashboardDefinitionRestDto;
import io.camunda.optimize.dto.optimize.query.dashboard.DashboardDefinitionUpdateDto;
import io.camunda.optimize.rest.exceptions.NotFoundException;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeDeleteRequestBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeIndexRequestBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeUpdateRequestBuilderES;
import io.camunda.optimize.service.db.repository.es.TaskRepositoryES;
import io.camunda.optimize.service.db.writer.DashboardWriter;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.service.util.IdGenerator;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class DashboardWriterES
implements DashboardWriter {
    private static final Logger LOG = LoggerFactory.getLogger(DashboardWriterES.class);
    private final OptimizeElasticsearchClient esClient;
    private final ObjectMapper objectMapper;
    private final TaskRepositoryES taskRepositoryES;

    public DashboardWriterES(OptimizeElasticsearchClient esClient, ObjectMapper objectMapper, TaskRepositoryES taskRepositoryES) {
        this.esClient = esClient;
        this.objectMapper = objectMapper;
        this.taskRepositoryES = taskRepositoryES;
    }

    @Override
    public IdResponseDto createNewDashboard(String userId, DashboardDefinitionRestDto dashboardDefinitionDto) {
        if (userId == null) {
            throw new OptimizeRuntimeException("userId is null");
        }
        if (dashboardDefinitionDto == null) {
            throw new OptimizeRuntimeException("dashboardDefinitionDto is null");
        }
        return this.createNewDashboard(userId, dashboardDefinitionDto, IdGenerator.getNextId());
    }

    @Override
    public IdResponseDto createNewDashboard(String userId, DashboardDefinitionRestDto dashboardDefinitionDto, String id) {
        LOG.debug("Writing new dashboard to Elasticsearch");
        if (userId == null) {
            throw new OptimizeRuntimeException("userId is null");
        }
        if (dashboardDefinitionDto == null) {
            throw new OptimizeRuntimeException("dashboardDefinitionDto is null");
        }
        if (id == null) {
            throw new OptimizeRuntimeException("id is null");
        }
        dashboardDefinitionDto.setOwner(userId);
        dashboardDefinitionDto.setName(Optional.ofNullable(dashboardDefinitionDto.getName()).orElse("New Dashboard"));
        dashboardDefinitionDto.setLastModifier(userId);
        dashboardDefinitionDto.setId(id);
        return this.saveDashboard(dashboardDefinitionDto);
    }

    @Override
    public IdResponseDto saveDashboard(DashboardDefinitionRestDto dashboardDefinitionDto) {
        if (dashboardDefinitionDto == null) {
            throw new OptimizeRuntimeException("dashboardDefinitionDto is null");
        }
        dashboardDefinitionDto.setCreated(LocalDateUtil.getCurrentDateTime());
        dashboardDefinitionDto.setLastModified(LocalDateUtil.getCurrentDateTime());
        String dashboardId = dashboardDefinitionDto.getId();
        try {
            IndexResponse indexResponse = this.esClient.index(OptimizeIndexRequestBuilderES.of(i -> i.optimizeIndex(this.esClient, "dashboard").id(dashboardId).document((Object)dashboardDefinitionDto).refresh(Refresh.True)));
            if (!indexResponse.result().equals((Object)Result.Created)) {
                String message = "Could not write dashboard to Elasticsearch. Maybe the connection to Elasticsearch was lost?";
                LOG.error("Could not write dashboard to Elasticsearch. Maybe the connection to Elasticsearch was lost?");
                throw new OptimizeRuntimeException("Could not write dashboard to Elasticsearch. Maybe the connection to Elasticsearch was lost?");
            }
        }
        catch (IOException e) {
            String errorMessage = "Could not create dashboard.";
            LOG.error("Could not create dashboard.", (Throwable)e);
            throw new OptimizeRuntimeException("Could not create dashboard.", (Throwable)e);
        }
        LOG.debug("Dashboard with id [{}] has successfully been created.", (Object)dashboardId);
        return new IdResponseDto(dashboardId);
    }

    @Override
    public void updateDashboard(DashboardDefinitionUpdateDto dashboard, String id) {
        LOG.debug("Updating dashboard with id [{}] in Elasticsearch", (Object)id);
        try {
            UpdateResponse updateResponse = this.esClient.update(new OptimizeUpdateRequestBuilderES().optimizeIndex(this.esClient, new String[]{"dashboard"}).id(id).doc((Object)dashboard).refresh(Refresh.True).retryOnConflict(Integer.valueOf(5)).build(), DashboardDefinitionUpdateDto.class);
            if (!updateResponse.shards().failures().isEmpty()) {
                LOG.error("Was not able to update dashboard with id [{}] and name [{}].", (Object)id, (Object)dashboard.getName());
                throw new OptimizeRuntimeException("Was not able to update dashboard!");
            }
        }
        catch (IOException e) {
            String errorMessage = String.format("Was not able to update dashboard with id [%s] and name [%s].", id, dashboard.getName());
            LOG.error(errorMessage, (Throwable)e);
            throw new OptimizeRuntimeException(errorMessage, (Throwable)e);
        }
        catch (ElasticsearchException e) {
            String errorMessage = String.format("Was not able to update dashboard with id [%s] and name [%s]. Dashboard does not exist!", id, dashboard.getName());
            LOG.error(errorMessage, (Throwable)e);
            throw new NotFoundException(errorMessage, (Throwable)e);
        }
    }

    @Override
    public void removeReportFromDashboards(String reportId) {
        String updateItem = String.format("report from dashboard with report ID [%s]", reportId);
        LOG.info("Removing {}}.", (Object)updateItem);
        Script removeReportFromDashboardScript = Script.of(s -> s.inline(i -> ((InlineScript.Builder)i.lang(ScriptLanguage.Painless).params("idToRemove", JsonData.of((Object)reportId))).source("ctx._source.tiles.removeIf(report -> report.id.equals(params.idToRemove))")));
        Query query = Query.of(q -> q.nested(n -> n.path("tiles").scoreMode(ChildScoreMode.None).query(Query.of(qq -> qq.term(t -> t.field("tiles.id").value(reportId))))));
        this.taskRepositoryES.tryUpdateByQueryRequest(updateItem, removeReportFromDashboardScript, query, "dashboard");
    }

    @Override
    public void deleteDashboardsOfCollection(String collectionId) {
        this.taskRepositoryES.tryDeleteByQueryRequest(Query.of(q -> q.term(t -> t.field("collectionId").value(collectionId))), String.format("dashboards of collection with ID [%s]", collectionId), true, "dashboard");
    }

    @Override
    public void deleteDashboard(String dashboardId) {
        DeleteResponse deleteResponse;
        LOG.debug("Deleting dashboard with id [{}]", (Object)dashboardId);
        try {
            deleteResponse = this.esClient.delete(OptimizeDeleteRequestBuilderES.of(d -> d.optimizeIndex(this.esClient, "dashboard").id(dashboardId).refresh(Refresh.True)));
        }
        catch (IOException e) {
            String reason = String.format("Could not delete dashboard with id [%s].", dashboardId);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        if (!deleteResponse.result().equals((Object)Result.Deleted)) {
            String message = String.format("Could not delete dashboard with id [%s]. Dashboard does not exist. Maybe it was already deleted by someone else?", dashboardId);
            LOG.error(message);
            throw new NotFoundException(message);
        }
    }

    @Override
    public void deleteManagementDashboard() {
        this.taskRepositoryES.tryDeleteByQueryRequest(Query.of(q -> q.term(t -> t.field("managementDashboard").value(true))), "Management Dashboard", true, "dashboard");
    }
}

