/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.view.process;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.FilterAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.NestedAggregate;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import io.camunda.optimize.dto.optimize.query.report.single.ViewProperty;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.view.VariableViewPropertyDto;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.rest.exceptions.BadRequestException;
import io.camunda.optimize.service.db.es.report.interpreter.view.process.AbstractProcessViewMultiAggregationInterpreterES;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.interpreter.view.process.ProcessViewVariableInterpreterHelper;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessView;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.db.util.ProcessVariableHelper;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.util.Map;
import java.util.Set;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class ProcessViewVariableInterpreterES
extends AbstractProcessViewMultiAggregationInterpreterES {
    private static final String NESTED_VARIABLE_AGGREGATION = "nestedVariableAggregation";
    private static final String FILTERED_VARIABLES_AGGREGATION = "filteredVariables";

    @Override
    public Set<ProcessView> getSupportedViews() {
        return Set.of(ProcessView.PROCESS_VIEW_VARIABLE);
    }

    @Override
    public ViewProperty getViewProperty(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        VariableViewPropertyDto variableViewDto = ProcessViewVariableInterpreterHelper.getVariableViewDto(context);
        return ViewProperty.variable((String)variableViewDto.getName(), (VariableType)variableViewDto.getType());
    }

    @Override
    public Map<String, Aggregation.Builder.ContainerBuilder> createAggregations(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        VariableViewPropertyDto variableViewDto = ProcessViewVariableInterpreterHelper.getVariableViewDto(context);
        VariableType variableType = variableViewDto.getType();
        if (!VariableType.getNumericTypes().contains(variableType)) {
            throw new BadRequestException("Only numeric variable types are supported for reports with view on variables!");
        }
        Aggregation.Builder.ContainerBuilder builder = new Aggregation.Builder().filter(f -> f.bool(bb -> bb.must(mm -> mm.term(t -> t.field(ProcessVariableHelper.getNestedVariableNameField()).value(variableViewDto.getName()))).must(mm -> mm.term(t -> t.field(ProcessVariableHelper.getNestedVariableTypeField()).value(variableType.getId()))).must(mm -> mm.exists(e -> e.field(ProcessVariableHelper.getNestedVariableValueFieldForType(variableType))))));
        this.getAggregationStrategies(context.getReportData()).stream().map(strategy -> strategy.createAggregationBuilder(null, ProcessVariableHelper.getNestedVariableValueFieldForType(variableType))).forEach(k -> builder.aggregations((String)k.key(), ((Aggregation.Builder.ContainerBuilder)k.value()).build()));
        Aggregation.Builder.ContainerBuilder aggBuilder = new Aggregation.Builder().nested(n -> n.path("variables"));
        aggBuilder.aggregations(FILTERED_VARIABLES_AGGREGATION, a -> builder);
        return Map.of(NESTED_VARIABLE_AGGREGATION, aggBuilder);
    }

    @Override
    public CompositeCommandResult.ViewResult retrieveResult(ResponseBody<?> response, Map<String, Aggregate> aggs, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        NestedAggregate nested = ((Aggregate)response.aggregations().get(NESTED_VARIABLE_AGGREGATION)).nested();
        FilterAggregate filterVariables = ((Aggregate)nested.aggregations().get(FILTERED_VARIABLES_AGGREGATION)).filter();
        CompositeCommandResult.ViewResult.ViewResultBuilder viewResultBuilder = CompositeCommandResult.ViewResult.builder();
        this.getAggregationStrategies(context.getReportData()).forEach(aggregationStrategy -> {
            Double measureResult = aggregationStrategy.getValue(filterVariables.aggregations());
            viewResultBuilder.viewMeasure(CompositeCommandResult.ViewMeasure.builder().aggregationType(aggregationStrategy.getAggregationType()).value(measureResult).build());
        });
        return viewResultBuilder.build();
    }
}

