/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.groupby.process.usertask;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.FilterAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.SingleBucketAggregateBase;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.es.filter.util.ModelElementFilterQueryUtilES;
import io.camunda.optimize.service.db.es.report.interpreter.groupby.process.AbstractProcessGroupByInterpreterES;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.interpreter.groupby.usertask.ProcessGroupByUserTaskInterpreterHelper;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractGroupByUserTaskInterpreterES
extends AbstractProcessGroupByInterpreterES {
    private static final String USER_TASKS_AGGREGATION = "userTasks";
    private static final String FLOW_NODE_AGGREGATION = "flowNodes";
    private static final String FILTERED_USER_TASKS_AGGREGATION = "filteredUserTasks";

    protected abstract DefinitionService getDefinitionService();

    protected abstract ProcessGroupByUserTaskInterpreterHelper getHelper();

    protected Map<String, Aggregation.Builder.ContainerBuilder> createFilteredUserTaskAggregation(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, BoolQuery baseQuery, String name, Aggregation subAggregation) {
        Aggregation.Builder.ContainerBuilder builder = new Aggregation.Builder().nested(n -> n.path("flowNodeInstances"));
        builder.aggregations(USER_TASKS_AGGREGATION, Aggregation.of(a -> {
            Aggregation.Builder.ContainerBuilder aggregations = a.filter(f -> f.bool(ModelElementFilterQueryUtilES.createUserTaskFlowNodeTypeFilter().build())).aggregations(FILTERED_USER_TASKS_AGGREGATION, Aggregation.of(aa -> aa.filter(f -> f.bool(ModelElementFilterQueryUtilES.createModelElementAggregationFilter((ProcessReportDataDto)context.getReportData(), context.getFilterContext(), this.getDefinitionService()).build())).aggregations(name, subAggregation)));
            this.getDistributedByInterpreter().createAggregations(context, baseQuery).forEach((k, v) -> aggregations.aggregations(k, v.build()));
            return aggregations;
        }));
        return Map.of(FLOW_NODE_AGGREGATION, builder);
    }

    protected Optional<FilterAggregate> getFilteredUserTaskAggregation(ResponseBody<?> response) {
        return this.getUserTasksAggregation(response).map(SingleBucketAggregateBase::aggregations).map(aggs -> ((Aggregate)aggs.get(FILTERED_USER_TASKS_AGGREGATION)).filter());
    }

    protected Optional<FilterAggregate> getUserTasksAggregation(ResponseBody<?> response) {
        return Optional.ofNullable(response.aggregations()).filter(f -> !f.isEmpty()).map(aggs -> ((Aggregate)aggs.get(FLOW_NODE_AGGREGATION)).nested()).map(flowNodeAgg -> ((Aggregate)flowNodeAgg.aggregations().get(USER_TASKS_AGGREGATION)).filter());
    }
}

