/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.groupby.process.identity;

import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.FilterAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.NestedAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.StringTermsAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.StringTermsBucket;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import co.elastic.clients.util.NamedValue;
import io.camunda.optimize.dto.optimize.IdentityType;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.AggregationDto;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.AggregationType;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.sorting.ReportSortingDto;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.es.filter.util.ModelElementFilterQueryUtilES;
import io.camunda.optimize.service.db.es.report.interpreter.groupby.process.AbstractProcessGroupByInterpreterES;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.interpreter.groupby.process.identity.ProcessGroupByIdentityInterpreterHelper;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractProcessGroupByIdentityInterpreterES
extends AbstractProcessGroupByInterpreterES {
    private static final String GROUP_BY_IDENTITY_TERMS_AGGREGATION = "identities";
    private static final String FLOW_NODES_AGGREGATION = "flowNodeInstances";
    private static final String USER_TASKS_AGGREGATION = "userTasks";
    private static final String FILTERED_USER_TASKS_AGGREGATION = "filteredUserTasks";
    private static final String GROUP_BY_IDENTITY_MISSING_KEY = "unassignedUserTasks___";

    protected abstract ConfigurationService getConfigurationService();

    protected abstract DefinitionService getDefinitionService();

    protected abstract ProcessGroupByIdentityInterpreterHelper getHelper();

    @Override
    public Map<String, Aggregation.Builder.ContainerBuilder> createAggregation(BoolQuery boolQuery, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        Aggregation.Builder.ContainerBuilder builder = new Aggregation.Builder().nested(n -> n.path(FLOW_NODES_AGGREGATION));
        builder.aggregations(USER_TASKS_AGGREGATION, Aggregation.of(a -> a.filter(f -> f.bool(ModelElementFilterQueryUtilES.createUserTaskFlowNodeTypeFilter().build())).aggregations(FILTERED_USER_TASKS_AGGREGATION, Aggregation.of(aa -> aa.filter(f -> f.bool(ModelElementFilterQueryUtilES.createInclusiveFlowNodeIdFilterQuery((ProcessReportDataDto)context.getReportData(), this.getHelper().getUserTaskIds((ProcessReportDataDto)context.getReportData()), context.getFilterContext(), this.getDefinitionService()).build())).aggregations(GROUP_BY_IDENTITY_TERMS_AGGREGATION, Aggregation.of(aaa -> {
            Aggregation.Builder.ContainerBuilder terms = aaa.terms(t -> t.size(this.getConfigurationService().getElasticSearchConfiguration().getAggregationBucketLimit()).field("flowNodeInstances." + this.getIdentityField()).order(NamedValue.of((String)"_key", (Object)SortOrder.Asc), new NamedValue[0]).missing(GROUP_BY_IDENTITY_MISSING_KEY));
            this.getDistributedByInterpreter().createAggregations(context, boolQuery).forEach((k, v) -> terms.aggregations(k, v.build()));
            return terms;
        }))))));
        return Map.of(FLOW_NODES_AGGREGATION, builder);
    }

    @Override
    public void addQueryResult(CompositeCommandResult compositeCommandResult, ResponseBody<?> response, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        Map aggregations = response.aggregations();
        NestedAggregate flowNodes = ((Aggregate)aggregations.get(FLOW_NODES_AGGREGATION)).nested();
        FilterAggregate userTasks = ((Aggregate)flowNodes.aggregations().get(USER_TASKS_AGGREGATION)).filter();
        FilterAggregate filteredUserTasks = ((Aggregate)userTasks.aggregations().get(FILTERED_USER_TASKS_AGGREGATION)).filter();
        List<CompositeCommandResult.GroupByResult> groupedData = this.getByIdentityAggregationResults(response, filteredUserTasks, context);
        compositeCommandResult.setGroups(groupedData);
        compositeCommandResult.setGroupBySorting(context.getReportConfiguration().getSorting().orElseGet(() -> new ReportSortingDto("label", io.camunda.optimize.dto.optimize.query.sorting.SortOrder.ASC)));
    }

    protected abstract String getIdentityField();

    protected abstract IdentityType getIdentityType();

    private List<CompositeCommandResult.GroupByResult> getByIdentityAggregationResults(ResponseBody<?> response, FilterAggregate filteredUserTasks, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        StringTermsAggregate byIdentityAggregation = ((Aggregate)filteredUserTasks.aggregations().get(GROUP_BY_IDENTITY_TERMS_AGGREGATION)).sterms();
        ArrayList<CompositeCommandResult.GroupByResult> groupedData = new ArrayList<CompositeCommandResult.GroupByResult>();
        for (StringTermsBucket identityBucket : byIdentityAggregation.buckets().array()) {
            boolean resultIsEmpty;
            String key = identityBucket.key().stringValue();
            List<CompositeCommandResult.DistributedByResult> distributedByResults = this.getDistributedByInterpreter().retrieveResult(response, identityBucket.aggregations(), context);
            if (GROUP_BY_IDENTITY_MISSING_KEY.equals(key)) {
                distributedByResults.forEach(result -> result.getViewResult().getViewMeasures().forEach(measure -> Optional.ofNullable(measure.getAggregationType()).map(AggregationDto::getType).ifPresent(aggregationType -> {
                    if (AggregationType.SUM.equals(aggregationType) && measure.getValue() != null && measure.getValue() == 0.0) {
                        measure.setValue(null);
                    }
                })));
            }
            boolean bl = resultIsEmpty = distributedByResults.isEmpty() || distributedByResults.stream().map(CompositeCommandResult.DistributedByResult::getViewResult).map(CompositeCommandResult.ViewResult::getViewMeasures).flatMap(Collection::stream).allMatch(viewMeasure -> viewMeasure.getValue() == null || viewMeasure.getValue() == 0.0);
            if (resultIsEmpty) continue;
            groupedData.add(CompositeCommandResult.GroupByResult.createGroupByResult(key, this.getHelper().resolveIdentityName(key, this::getIdentityType), distributedByResults));
        }
        return groupedData;
    }
}

