/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.groupby.process.flownode;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.StringTermsBucket;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.es.report.interpreter.distributedby.process.ProcessDistributedByInterpreterFacadeES;
import io.camunda.optimize.service.db.es.report.interpreter.groupby.process.flownode.AbstractGroupByFlowNodeInterpreterES;
import io.camunda.optimize.service.db.es.report.interpreter.view.process.ProcessViewInterpreterFacadeES;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.groupby.flownode.ProcessGroupByFlowNodeInterpreterHelper;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class ProcessGroupByFlowNodeInterpreterES
extends AbstractGroupByFlowNodeInterpreterES {
    private static final String NESTED_EVENTS_AGGREGATION = "nestedEvents";
    final ProcessDistributedByInterpreterFacadeES distributedByInterpreter;
    final ProcessViewInterpreterFacadeES viewInterpreter;
    private final ConfigurationService configurationService;
    private final DefinitionService definitionService;
    private final ProcessGroupByFlowNodeInterpreterHelper helper;

    public ProcessGroupByFlowNodeInterpreterES(ProcessDistributedByInterpreterFacadeES distributedByInterpreter, ProcessViewInterpreterFacadeES viewInterpreter, ConfigurationService configurationService, DefinitionService definitionService, ProcessGroupByFlowNodeInterpreterHelper helper) {
        this.distributedByInterpreter = distributedByInterpreter;
        this.viewInterpreter = viewInterpreter;
        this.configurationService = configurationService;
        this.definitionService = definitionService;
        this.helper = helper;
    }

    @Override
    public Set<ProcessGroupBy> getSupportedGroupBys() {
        return Set.of(ProcessGroupBy.PROCESS_GROUP_BY_FLOW_NODE);
    }

    @Override
    public Map<String, Aggregation.Builder.ContainerBuilder> createAggregation(BoolQuery boolQuery, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        Aggregation.Builder.ContainerBuilder builder = new Aggregation.Builder().terms(t -> t.size(this.configurationService.getElasticSearchConfiguration().getAggregationBucketLimit()).field("flowNodeInstances.flowNodeId"));
        this.distributedByInterpreter.createAggregations(context, boolQuery).forEach((k, v) -> builder.aggregations(k, v.build()));
        return this.createFilteredFlowNodeAggregation(context, Map.of(NESTED_EVENTS_AGGREGATION, builder));
    }

    @Override
    public void addQueryResult(CompositeCommandResult compositeCommandResult, ResponseBody<?> response, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        this.getFilteredFlowNodesAggregation(response).map(filteredFlowNodes -> ((Aggregate)filteredFlowNodes.aggregations().get(NESTED_EVENTS_AGGREGATION)).sterms()).ifPresent(byFlowNodeIdAggregation -> {
            Map<String, String> flowNodeNames = this.helper.getFlowNodeNames((ProcessReportDataDto)context.getReportData());
            ArrayList<CompositeCommandResult.GroupByResult> groupedData = new ArrayList<CompositeCommandResult.GroupByResult>();
            for (StringTermsBucket flowNodeBucket : byFlowNodeIdAggregation.buckets().array()) {
                String flowNodeKey = flowNodeBucket.key().stringValue();
                if (!flowNodeNames.containsKey(flowNodeKey)) continue;
                List<CompositeCommandResult.DistributedByResult> singleResult = this.distributedByInterpreter.retrieveResult(response, (Map<String, Aggregate>)flowNodeBucket.aggregations(), context);
                String label = flowNodeNames.get(flowNodeKey);
                groupedData.add(CompositeCommandResult.GroupByResult.createGroupByResult(flowNodeKey, label, singleResult));
                flowNodeNames.remove(flowNodeKey);
            }
            this.helper.addMissingGroupByKeys(flowNodeNames, groupedData, context, this.distributedByInterpreter.createEmptyResult(context));
            this.helper.removeHiddenModelElements(groupedData, context);
            compositeCommandResult.setGroups(groupedData);
        });
    }

    public ProcessDistributedByInterpreterFacadeES getDistributedByInterpreter() {
        return this.distributedByInterpreter;
    }

    public ProcessViewInterpreterFacadeES getViewInterpreter() {
        return this.viewInterpreter;
    }

    @Override
    public DefinitionService getDefinitionService() {
        return this.definitionService;
    }
}

