/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.groupby.process.flownode;

import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.es.report.interpreter.distributedby.process.ProcessDistributedByInterpreterFacadeES;
import io.camunda.optimize.service.db.es.report.interpreter.groupby.process.flownode.AbstractGroupByFlowNodeInterpreterES;
import io.camunda.optimize.service.db.es.report.interpreter.util.DurationScriptUtilES;
import io.camunda.optimize.service.db.es.report.interpreter.view.process.ProcessViewInterpreterFacadeES;
import io.camunda.optimize.service.db.es.report.service.DurationAggregationServiceES;
import io.camunda.optimize.service.db.es.report.service.MinMaxStatsServiceES;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class ProcessGroupByFlowNodeDurationInterpreterES
extends AbstractGroupByFlowNodeInterpreterES {
    final ProcessDistributedByInterpreterFacadeES distributedByInterpreter;
    final ProcessViewInterpreterFacadeES viewInterpreter;
    private final MinMaxStatsServiceES minMaxStatsService;
    private final DefinitionService definitionService;
    private final DurationAggregationServiceES durationAggregationService;

    public ProcessGroupByFlowNodeDurationInterpreterES(MinMaxStatsServiceES minMaxStatsService, DefinitionService definitionService, ProcessDistributedByInterpreterFacadeES distributedByInterpreter, DurationAggregationServiceES durationAggregationService, ProcessViewInterpreterFacadeES viewInterpreter) {
        this.minMaxStatsService = minMaxStatsService;
        this.definitionService = definitionService;
        this.distributedByInterpreter = distributedByInterpreter;
        this.durationAggregationService = durationAggregationService;
        this.viewInterpreter = viewInterpreter;
    }

    @Override
    public Set<ProcessGroupBy> getSupportedGroupBys() {
        return Set.of(ProcessGroupBy.PROCESS_GROUP_BY_FLOW_NODE_DURATION);
    }

    @Override
    public Map<String, Aggregation.Builder.ContainerBuilder> createAggregation(BoolQuery boolQuery, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return this.durationAggregationService.createLimitedGroupByScriptedEventDurationAggregation(boolQuery, context, this.getDurationScript()).map(durationAggregation -> this.createFilteredFlowNodeAggregation(context, (Map<String, Aggregation.Builder.ContainerBuilder>)durationAggregation)).orElse(Map.of());
    }

    @Override
    public Optional<MinMaxStatDto> getMinMaxStats(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Query baseQuery) {
        return Optional.of(this.retrieveMinMaxDurationStats(context, baseQuery));
    }

    @Override
    public void addQueryResult(CompositeCommandResult compositeCommandResult, ResponseBody<?> response, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        compositeCommandResult.setGroupByKeyOfNumericType(true);
        compositeCommandResult.setDistributedByKeyOfNumericType(this.distributedByInterpreter.isKeyOfNumericType(context));
        this.getFilteredFlowNodesAggregation(response).ifPresent(filteredFlowNodes -> {
            List<CompositeCommandResult.GroupByResult> durationHistogramData = this.durationAggregationService.mapGroupByDurationResults(response, filteredFlowNodes.aggregations(), context);
            compositeCommandResult.setGroups(durationHistogramData);
        });
    }

    public ProcessDistributedByInterpreterFacadeES getDistributedByInterpreter() {
        return this.distributedByInterpreter;
    }

    public ProcessViewInterpreterFacadeES getViewInterpreter() {
        return this.viewInterpreter;
    }

    private MinMaxStatDto retrieveMinMaxDurationStats(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Query baseQuery) {
        return this.minMaxStatsService.getScriptedMinMaxStats(baseQuery, this.getIndexNames(context), "flowNodeInstances", this.getDurationScript());
    }

    private Script getDurationScript() {
        return DurationScriptUtilES.getDurationScript(LocalDateUtil.getCurrentDateTime().toInstant().toEpochMilli(), "flowNodeInstances.totalDurationInMs", "flowNodeInstances.startDate");
    }

    @Override
    public DefinitionService getDefinitionService() {
        return this.definitionService;
    }
}

