/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.groupby.decision;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import io.camunda.optimize.dto.optimize.query.report.single.decision.DecisionReportDataDto;
import io.camunda.optimize.service.db.es.report.interpreter.distributedby.decision.DecisionDistributedByNoneInterpreterES;
import io.camunda.optimize.service.db.es.report.interpreter.groupby.decision.AbstractDecisionGroupByInterpreterES;
import io.camunda.optimize.service.db.es.report.interpreter.view.decision.DecisionViewInterpreterFacadeES;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.plan.decision.DecisionExecutionPlan;
import io.camunda.optimize.service.db.report.plan.decision.DecisionGroupBy;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class DecisionGroupByNoneInterpreterES
extends AbstractDecisionGroupByInterpreterES {
    private final DecisionDistributedByNoneInterpreterES distributedByInterpreter;
    private final DecisionViewInterpreterFacadeES viewInterpreter;

    public DecisionGroupByNoneInterpreterES(DecisionDistributedByNoneInterpreterES distributedByInterpreter, DecisionViewInterpreterFacadeES viewInterpreter) {
        this.distributedByInterpreter = distributedByInterpreter;
        this.viewInterpreter = viewInterpreter;
    }

    @Override
    public Map<String, Aggregation.Builder.ContainerBuilder> createAggregation(BoolQuery boolQuery, ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context) {
        return this.distributedByInterpreter.createAggregations(context, boolQuery).entrySet().stream().filter(e -> Objects.nonNull(e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public void addQueryResult(CompositeCommandResult compositeCommandResult, ResponseBody<?> response, ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context) {
        List<CompositeCommandResult.DistributedByResult> distributions = this.distributedByInterpreter.retrieveResult(response, (Map<String, Aggregate>)response.aggregations(), context);
        CompositeCommandResult.GroupByResult groupByResult = CompositeCommandResult.GroupByResult.createGroupByNone(distributions);
        compositeCommandResult.setGroup(groupByResult);
    }

    @Override
    public Set<DecisionGroupBy> getSupportedGroupBys() {
        return Set.of(DecisionGroupBy.DECISION_GROUP_BY_NONE);
    }

    public DecisionDistributedByNoneInterpreterES getDistributedByInterpreter() {
        return this.distributedByInterpreter;
    }

    public DecisionViewInterpreterFacadeES getViewInterpreter() {
        return this.viewInterpreter;
    }
}

