/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.groupby.decision;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import io.camunda.optimize.dto.optimize.query.report.single.decision.DecisionReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.group.DecisionGroupByEvaluationDateTimeDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.group.value.DecisionGroupByEvaluationDateTimeValueDto;
import io.camunda.optimize.dto.optimize.query.report.single.group.AggregateByDateUnit;
import io.camunda.optimize.dto.optimize.query.sorting.ReportSortingDto;
import io.camunda.optimize.dto.optimize.query.sorting.SortOrder;
import io.camunda.optimize.service.db.es.filter.DecisionQueryFilterEnhancerES;
import io.camunda.optimize.service.db.es.report.context.DateAggregationContextES;
import io.camunda.optimize.service.db.es.report.interpreter.distributedby.decision.DecisionDistributedByNoneInterpreterES;
import io.camunda.optimize.service.db.es.report.interpreter.groupby.decision.AbstractDecisionGroupByInterpreterES;
import io.camunda.optimize.service.db.es.report.interpreter.util.FilterLimitedAggregationUtilES;
import io.camunda.optimize.service.db.es.report.interpreter.view.decision.DecisionViewInterpreterFacadeES;
import io.camunda.optimize.service.db.es.report.service.DateAggregationServiceES;
import io.camunda.optimize.service.db.es.report.service.MinMaxStatsServiceES;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.db.report.context.DateAggregationContext;
import io.camunda.optimize.service.db.report.plan.decision.DecisionExecutionPlan;
import io.camunda.optimize.service.db.report.plan.decision.DecisionGroupBy;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class DecisionGroupByEvaluationDateTimeInterpreterES
extends AbstractDecisionGroupByInterpreterES {
    private final DateAggregationServiceES dateAggregationService;
    private final MinMaxStatsServiceES minMaxStatsService;
    private final DecisionQueryFilterEnhancerES queryFilterEnhancer;
    private final DecisionDistributedByNoneInterpreterES distributedByInterpreter;
    private final DecisionViewInterpreterFacadeES viewInterpreter;

    public DecisionGroupByEvaluationDateTimeInterpreterES(DateAggregationServiceES dateAggregationService, MinMaxStatsServiceES minMaxStatsService, DecisionQueryFilterEnhancerES queryFilterEnhancer, DecisionDistributedByNoneInterpreterES distributedByInterpreter, DecisionViewInterpreterFacadeES viewInterpreter) {
        this.dateAggregationService = dateAggregationService;
        this.minMaxStatsService = minMaxStatsService;
        this.queryFilterEnhancer = queryFilterEnhancer;
        this.distributedByInterpreter = distributedByInterpreter;
        this.viewInterpreter = viewInterpreter;
    }

    @Override
    public Map<String, Aggregation.Builder.ContainerBuilder> createAggregation(BoolQuery boolQuery, ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context) {
        AggregateByDateUnit unit = this.getGroupBy(context.getReportData()).getUnit();
        return this.createAggregation(boolQuery, context, unit);
    }

    private Map<String, Aggregation.Builder.ContainerBuilder> createAggregation(BoolQuery boolQuery, ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context, AggregateByDateUnit unit) {
        MinMaxStatDto stats = this.minMaxStatsService.getMinMaxDateRange(context, Query.of(q -> q.bool(boolQuery)), this.getIndexNames(context), "evaluationDateTime");
        DateAggregationContext dateAggContext = ((DateAggregationContextES.DateAggregationContextESBuilder)((DateAggregationContext.DateAggregationContextBuilder)((DateAggregationContextES.DateAggregationContextESBuilder)((DateAggregationContext.DateAggregationContextBuilder)((DateAggregationContextES.DateAggregationContextESBuilder)((DateAggregationContextES.DateAggregationContextESBuilder)((DateAggregationContextES.DateAggregationContextESBuilder)((DateAggregationContextES.DateAggregationContextESBuilder)DateAggregationContextES.builder().aggregateByDateUnit(unit)).dateField("evaluationDateTime")).minMaxStats(stats)).timezone(context.getTimezone())).subAggregations(this.getDistributedByInterpreter().createAggregations(context, boolQuery))).decisionFilters(context.getReportData().getFilter())).decisionQueryFilterEnhancer(this.queryFilterEnhancer)).filterContext(context.getFilterContext())).build();
        return this.dateAggregationService.createDecisionEvaluationDateAggregation((DateAggregationContextES)dateAggContext).orElse(Map.of());
    }

    @Override
    public void addQueryResult(CompositeCommandResult result, ResponseBody<?> response, ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context) {
        result.setGroups(this.processAggregations(response, context));
        result.setGroupBySorting(context.getReportConfiguration().getSorting().orElseGet(() -> new ReportSortingDto("key", SortOrder.DESC)));
    }

    private DecisionGroupByEvaluationDateTimeValueDto getGroupBy(DecisionReportDataDto reportData) {
        return (DecisionGroupByEvaluationDateTimeValueDto)((DecisionGroupByEvaluationDateTimeDto)reportData.getGroupBy()).getValue();
    }

    private List<CompositeCommandResult.GroupByResult> processAggregations(ResponseBody<?> response, ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context) {
        Map aggregations = response.aggregations();
        if (aggregations == null) {
            return Collections.emptyList();
        }
        Optional<Map<String, Aggregate>> unwrappedLimitedAggregations = FilterLimitedAggregationUtilES.unwrapFilterLimitedAggregations(aggregations);
        if (!unwrappedLimitedAggregations.isPresent()) {
            return Collections.emptyList();
        }
        Map<String, Map<String, Aggregate>> keyToAggregationMap = this.dateAggregationService.mapDateAggregationsToKeyAggregationMap(unwrappedLimitedAggregations.get(), context.getTimezone());
        return this.mapKeyToAggMapToGroupByResults(keyToAggregationMap, response, context);
    }

    private List<CompositeCommandResult.GroupByResult> mapKeyToAggMapToGroupByResults(Map<String, Map<String, Aggregate>> keyToAggregationMap, ResponseBody<?> response, ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context) {
        return keyToAggregationMap.entrySet().stream().map(stringBucketEntry -> CompositeCommandResult.GroupByResult.createGroupByResult((String)stringBucketEntry.getKey(), this.getDistributedByInterpreter().retrieveResult(response, (Map<String, Aggregate>)((Map)stringBucketEntry.getValue()), context))).collect(Collectors.toList());
    }

    @Override
    public Set<DecisionGroupBy> getSupportedGroupBys() {
        return Set.of(DecisionGroupBy.DECISION_GROUP_BY_EVALUATION_DATE_TIME);
    }

    public DecisionDistributedByNoneInterpreterES getDistributedByInterpreter() {
        return this.distributedByInterpreter;
    }

    public DecisionViewInterpreterFacadeES getViewInterpreter() {
        return this.viewInterpreter;
    }
}

