/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.distributedby.process.model;

import io.camunda.optimize.dto.optimize.DefinitionOptimizeResponseDto;
import io.camunda.optimize.dto.optimize.FlowNodeDataDto;
import io.camunda.optimize.dto.optimize.ProcessDefinitionOptimizeDto;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.es.report.interpreter.distributedby.process.model.AbstractProcessDistributedByModelElementInterpreterES;
import io.camunda.optimize.service.db.es.report.interpreter.view.process.ProcessViewInterpreterFacadeES;
import io.camunda.optimize.service.db.report.interpreter.distributedby.process.model.ProcessDistributedByModelElementInterpreterHelper;
import io.camunda.optimize.service.db.report.plan.process.ProcessDistributedBy;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class ProcessDistributedByFlowNodeInterpreterES
extends AbstractProcessDistributedByModelElementInterpreterES {
    private final ConfigurationService configurationService;
    private final DefinitionService definitionService;
    private final ProcessViewInterpreterFacadeES viewInterpreter;
    private final ProcessDistributedByModelElementInterpreterHelper helper;

    public ProcessDistributedByFlowNodeInterpreterES(ConfigurationService configurationService, DefinitionService definitionService, ProcessViewInterpreterFacadeES viewInterpreter, ProcessDistributedByModelElementInterpreterHelper helper) {
        this.configurationService = configurationService;
        this.definitionService = definitionService;
        this.viewInterpreter = viewInterpreter;
        this.helper = helper;
    }

    @Override
    public Set<ProcessDistributedBy> getSupportedDistributedBys() {
        return Set.of(ProcessDistributedBy.PROCESS_DISTRIBUTED_BY_FLOW_NODE);
    }

    @Override
    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    @Override
    public DefinitionService getDefinitionService() {
        return this.definitionService;
    }

    @Override
    protected ProcessDistributedByModelElementInterpreterHelper getHelper() {
        return this.helper;
    }

    @Override
    protected String getModelElementIdPath() {
        return "flowNodeInstances.flowNodeId";
    }

    @Override
    protected Map<String, FlowNodeDataDto> extractModelElementData(DefinitionOptimizeResponseDto def) {
        return ((ProcessDefinitionOptimizeDto)def).getFlowNodeData().stream().collect(Collectors.toMap(FlowNodeDataDto::getId, Function.identity()));
    }

    public ProcessViewInterpreterFacadeES getViewInterpreter() {
        return this.viewInterpreter;
    }
}

