/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.reader;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.query_dsl.ChildScoreMode;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.CountRequest;
import co.elastic.clients.elasticsearch.core.GetRequest;
import co.elastic.clients.elasticsearch.core.GetResponse;
import co.elastic.clients.elasticsearch.core.MgetRequest;
import co.elastic.clients.elasticsearch.core.MgetResponse;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.get.GetResult;
import co.elastic.clients.elasticsearch.core.mget.MultiGetOperation;
import co.elastic.clients.elasticsearch.core.mget.MultiGetResponseItem;
import co.elastic.clients.elasticsearch.core.search.Hit;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.ReportType;
import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.combined.CombinedReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.SingleDecisionReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.SingleProcessReportDefinitionRequestDto;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeCountRequestBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeGetRequestBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeMultiGetOperationBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeSearchRequestBuilderES;
import io.camunda.optimize.service.db.es.reader.ElasticsearchReaderUtil;
import io.camunda.optimize.service.db.reader.ReportReader;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class ReportReaderES
implements ReportReader {
    private static final Logger LOG = LoggerFactory.getLogger(ReportReaderES.class);
    private final OptimizeElasticsearchClient esClient;
    private final ConfigurationService configurationService;
    private final ObjectMapper objectMapper;

    public ReportReaderES(OptimizeElasticsearchClient esClient, ConfigurationService configurationService, ObjectMapper objectMapper) {
        this.esClient = esClient;
        this.configurationService = configurationService;
        this.objectMapper = objectMapper;
    }

    @Override
    public Optional<ReportDefinitionDto> getReport(String reportId) {
        LOG.debug("Fetching report with id [{}]", (Object)reportId);
        MgetResponse<ReportDefinitionDto> multiGetItemResponses = this.performMultiGetReportRequest(reportId, ReportDefinitionDto.class);
        Optional<ReportDefinitionDto> result = Optional.empty();
        for (MultiGetResponseItem itemResponse : multiGetItemResponses.docs()) {
            GetResult response = itemResponse.result();
            Optional<ReportDefinitionDto> reportDefinitionDto = this.processGetReportResponse(reportId, (GetResult<ReportDefinitionDto>)response);
            if (!reportDefinitionDto.isPresent()) continue;
            result = reportDefinitionDto;
            break;
        }
        return result;
    }

    @Override
    public Optional<SingleProcessReportDefinitionRequestDto> getSingleProcessReportOmitXml(String reportId) {
        GetResponse getResponse;
        LOG.debug("Fetching single process report with id [{}]", (Object)reportId);
        GetRequest getRequest = this.getGetRequestOmitXml("single-process-report", reportId);
        try {
            getResponse = this.esClient.get(getRequest, SingleProcessReportDefinitionRequestDto.class);
        }
        catch (IOException e) {
            String reason = String.format("Could not fetch single process report with id [%s]", reportId);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        if (!getResponse.found()) {
            return Optional.empty();
        }
        return Optional.of((SingleProcessReportDefinitionRequestDto)getResponse.source());
    }

    @Override
    public Optional<SingleDecisionReportDefinitionRequestDto> getSingleDecisionReportOmitXml(String reportId) {
        GetResponse getResponse;
        LOG.debug("Fetching single decision report with id [{}]", (Object)reportId);
        GetRequest getRequest = this.getGetRequestOmitXml("single-decision-report", reportId);
        try {
            getResponse = this.esClient.get(getRequest, SingleDecisionReportDefinitionRequestDto.class);
        }
        catch (IOException e) {
            String reason = String.format("Could not fetch single decision report with id [%s]", reportId);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        if (!getResponse.found()) {
            return Optional.empty();
        }
        return Optional.of((SingleDecisionReportDefinitionRequestDto)getResponse.source());
    }

    @Override
    public List<ReportDefinitionDto> getAllReportsForIdsOmitXml(List<String> reportIds) {
        if (reportIds.isEmpty()) {
            LOG.debug("No report IDs supplied so no reports to fetch");
            return Collections.emptyList();
        }
        LOG.debug("Fetching all report definitions for Ids {}", reportIds);
        Query.Builder qb = new Query.Builder();
        qb.ids(i -> i.values(reportIds));
        SearchResponse<ReportDefinitionDto> searchResponse = this.performGetReportRequestOmitXml(qb, ALL_REPORT_INDICES, 1000, ReportDefinitionDto.class);
        return ElasticsearchReaderUtil.retrieveAllScrollResults(searchResponse, ReportDefinitionDto.class, this.objectMapper, this.esClient, (Integer)this.configurationService.getElasticSearchConfiguration().getScrollTimeoutInSeconds());
    }

    @Override
    public List<ReportDefinitionDto> getAllReportsForProcessDefinitionKeyOmitXml(String definitionKey) {
        List<ReportDefinitionDto> processReportsForKey = this.getAllProcessReportsForDefinitionKeyOmitXml(definitionKey);
        List<String> processReportIds = processReportsForKey.stream().map(ReportDefinitionDto::getId).collect(Collectors.toList());
        List<CombinedReportDefinitionRequestDto> combinedReports = this.getCombinedReportsForSimpleReports(processReportIds);
        processReportsForKey.addAll(combinedReports);
        return processReportsForKey;
    }

    @Override
    public List<ReportDefinitionDto> getAllPrivateReportsOmitXml() {
        LOG.debug("Fetching all available private reports");
        Query.Builder qb = new Query.Builder();
        qb.bool(b -> b.mustNot(m -> m.term(t -> t.field("data.managementReport").value(true))).mustNot(m -> m.term(t -> t.field("data.instantPreviewReport").value(true))).mustNot(m -> m.exists(e -> e.field("collectionId"))));
        SearchResponse<ReportDefinitionDto> searchResponse = this.performGetReportRequestOmitXml(qb, ALL_REPORT_INDICES, 1000, ReportDefinitionDto.class);
        return ElasticsearchReaderUtil.retrieveAllScrollResults(searchResponse, ReportDefinitionDto.class, this.objectMapper, this.esClient, (Integer)this.configurationService.getElasticSearchConfiguration().getScrollTimeoutInSeconds());
    }

    @Override
    public List<SingleProcessReportDefinitionRequestDto> getAllSingleProcessReportsForIdsOmitXml(List<String> reportIds) {
        LOG.debug("Fetching all available single process reports for IDs [{}]", reportIds);
        Class<SingleProcessReportDefinitionRequestDto> reportType = SingleProcessReportDefinitionRequestDto.class;
        String[] indices = new String[]{"single-process-report"};
        return this.getReportDefinitionDtos(reportIds, reportType, indices);
    }

    @Override
    public List<ReportDefinitionDto> getReportsForCollectionOmitXml(String collectionId) {
        return this.getReportsForCollection(collectionId, false);
    }

    @Override
    public List<ReportDefinitionDto> getReportsForCollectionIncludingXml(String collectionId) {
        return this.getReportsForCollection(collectionId, true);
    }

    @Override
    public List<CombinedReportDefinitionRequestDto> getCombinedReportsForSimpleReport(String simpleReportId) {
        return this.getCombinedReportsForSimpleReports(Collections.singletonList(simpleReportId));
    }

    @Override
    public long getReportCount(ReportType reportType) {
        CountRequest countRequest = ReportType.PROCESS.equals((Object)reportType) ? OptimizeCountRequestBuilderES.of(r -> r.optimizeIndex(this.esClient, "single-process-report").query(q -> q.bool(b -> b.mustNot(m -> m.term(t -> t.field("data.managementReport").value(true))).mustNot(m -> m.term(t -> t.field("data.instantPreviewReport").value(true)))))) : OptimizeCountRequestBuilderES.of(f -> f.optimizeIndex(this.esClient, "single-decision-report"));
        try {
            return this.esClient.count(countRequest).count();
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException("Was not able to retrieve report counts!", (Throwable)e);
        }
    }

    @Override
    public long getUserTaskReportCount() {
        SearchResponse searchResponse;
        Query.Builder builder = new Query.Builder();
        builder.bool(b -> b.mustNot(m -> m.term(t -> t.field("data.managementReport").value(true))).mustNot(m -> m.term(t -> t.field("data.instantPreviewReport").value(true))));
        SearchRequest searchRequest = this.getSearchRequestOmitXml(builder, new String[]{"single-process-report"}).build();
        try {
            searchResponse = this.esClient.search(searchRequest, SingleProcessReportDefinitionRequestDto.class);
        }
        catch (IOException e) {
            String reason = "Was not able to fetch process reports to count userTask reports.";
            LOG.error("Was not able to fetch process reports to count userTask reports.", (Throwable)e);
            throw new OptimizeRuntimeException("Was not able to fetch process reports to count userTask reports.", (Throwable)e);
        }
        List<SingleProcessReportDefinitionRequestDto> allProcessReports = ElasticsearchReaderUtil.mapHits(searchResponse.hits(), SingleProcessReportDefinitionRequestDto.class, this.objectMapper);
        return allProcessReports.stream().filter(report -> ((ProcessReportDataDto)report.getData()).isUserTaskReport()).count();
    }

    private List<ReportDefinitionDto> getAllProcessReportsForDefinitionKeyOmitXml(String definitionKey) {
        LOG.debug("Fetching all available process reports for process definition key {}", (Object)definitionKey);
        Query.Builder builder = new Query.Builder();
        builder.bool(b -> b.must(m -> m.term(t -> t.field(String.join((CharSequence)".", "data", "definitions", "key")).value(definitionKey))));
        SearchResponse<ReportDefinitionDto> searchResponse = this.performGetReportRequestOmitXml(builder, new String[]{"single-process-report"}, 1000, ReportDefinitionDto.class);
        return ElasticsearchReaderUtil.retrieveAllScrollResults(searchResponse, ReportDefinitionDto.class, this.objectMapper, this.esClient, (Integer)this.configurationService.getElasticSearchConfiguration().getScrollTimeoutInSeconds());
    }

    private List<CombinedReportDefinitionRequestDto> getCombinedReportsForSimpleReports(List<String> simpleReportIds) {
        SearchResponse searchResponse;
        LOG.debug("Fetching first combined reports using simpleReports with ids {}", simpleReportIds);
        Query.Builder builder = new Query.Builder();
        builder.nested(n -> n.path("data").query(q -> q.nested(nn -> nn.query(qq -> qq.terms(t -> t.field(String.join((CharSequence)".", "data", "reports", "id")).terms(tt -> tt.value(simpleReportIds.stream().map(FieldValue::of).toList())))).path(String.join((CharSequence)".", "data", "reports")).scoreMode(ChildScoreMode.None))).scoreMode(ChildScoreMode.None));
        SearchRequest searchRequest = this.getSearchRequestOmitXml(builder, new String[]{"combined-report"}).build();
        try {
            searchResponse = this.esClient.search(searchRequest, CombinedReportDefinitionRequestDto.class);
        }
        catch (IOException e) {
            String reason = String.format("Was not able to fetch combined reports that contain reports with ids [%s]", simpleReportIds);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        return ElasticsearchReaderUtil.mapHits(searchResponse.hits(), CombinedReportDefinitionRequestDto.class, this.objectMapper);
    }

    private List<ReportDefinitionDto> getReportsForCollection(String collectionId, boolean includeXml) {
        LOG.debug("Fetching reports using collection with id {}", (Object)collectionId);
        Query.Builder qb = new Query.Builder();
        qb.bool(b -> b.must(m -> m.term(t -> t.field("collectionId").value(collectionId))).mustNot(m -> m.term(t -> t.field("data.managementReport").value(true))).mustNot(m -> m.term(t -> t.field("data.instantPreviewReport").value(true))));
        String[] indices = new String[]{"combined-report", "single-process-report", "single-decision-report"};
        SearchRequest searchRequest = includeXml ? this.getSearchRequestIncludingXml(qb, indices).build() : this.getSearchRequestOmitXml(qb, indices).build();
        try {
            SearchResponse searchResponse = this.esClient.search(searchRequest, ReportDefinitionDto.class);
            return ElasticsearchReaderUtil.mapHits(searchResponse.hits(), ReportDefinitionDto.class, this.objectMapper);
        }
        catch (IOException e) {
            String reason = String.format("Was not able to fetch reports for collection with id [%s]", collectionId);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
    }

    private <T extends ReportDefinitionDto> List<T> getReportDefinitionDtos(List<String> reportIds, Class<T> reportType, String[] indices) {
        if (reportIds.isEmpty()) {
            return Collections.emptyList();
        }
        Query.Builder builder = new Query.Builder();
        builder.ids(i -> i.values(reportIds));
        SearchResponse<T> searchResponse = this.performGetReportRequestOmitXml(builder, indices, reportIds.size(), reportType);
        return this.mapResponseToReportList(searchResponse, reportType).stream().sorted(Comparator.comparingInt(a -> reportIds.indexOf(a.getId()))).collect(Collectors.toList());
    }

    private <T extends ReportDefinitionDto> List<T> mapResponseToReportList(SearchResponse<T> searchResponse, Class<T> c) {
        ArrayList<ReportDefinitionDto> reportDefinitionDtos = new ArrayList<ReportDefinitionDto>();
        for (Hit hit : searchResponse.hits().hits()) {
            reportDefinitionDtos.add((ReportDefinitionDto)hit.source());
        }
        return reportDefinitionDtos;
    }

    private Optional<ReportDefinitionDto> processGetReportResponse(String reportId, GetResult<ReportDefinitionDto> getResponse) {
        Optional<ReportDefinitionDto> result = Optional.empty();
        if (getResponse != null && getResponse.found()) {
            return Optional.of((ReportDefinitionDto)getResponse.source());
        }
        return result;
    }

    private GetRequest getGetRequestOmitXml(String index, String reportId) {
        return OptimizeGetRequestBuilderES.of(g -> g.optimizeIndex(this.esClient, index).id(reportId).sourceExcludes(List.of(REPORT_LIST_EXCLUDES)).source(s -> s.fetch(Boolean.valueOf(true))));
    }

    private SearchRequest.Builder getSearchRequestOmitXml(Query.Builder query, String[] indices) {
        return this.getSearchRequestOmitXml(query, indices, 1000);
    }

    private SearchRequest.Builder getSearchRequestIncludingXml(Query.Builder query, String[] indices) {
        return this.getSearchRequest(query, indices, 1000, new String[0]);
    }

    private SearchRequest.Builder getSearchRequestOmitXml(Query.Builder query, String[] indices, int size) {
        return this.getSearchRequest(query, indices, size, REPORT_LIST_EXCLUDES);
    }

    private SearchRequest.Builder getSearchRequest(Query.Builder query, String[] indices, int size, String[] excludeFields) {
        OptimizeSearchRequestBuilderES builder = new OptimizeSearchRequestBuilderES();
        builder.optimizeIndex(this.esClient, indices);
        builder.query(query.build());
        builder.size(Integer.valueOf(size));
        if (excludeFields.length == 0) {
            builder.source(s -> s.fetch(Boolean.valueOf(true)));
        } else {
            builder.source(s -> s.filter(f -> f.excludes(List.of(excludeFields))));
        }
        return builder;
    }

    private <T> SearchResponse<T> performGetReportRequestOmitXml(Query.Builder query, String[] indices, int size, Class<T> clas) {
        SearchRequest.Builder searchRequestBuilder = this.getSearchRequestOmitXml(query, indices, size).scroll(s -> s.time(this.configurationService.getElasticSearchConfiguration().getScrollTimeoutInSeconds() + "s"));
        try {
            return this.esClient.search(searchRequestBuilder.build(), clas);
        }
        catch (IOException e) {
            LOG.error("Was not able to retrieve reports!", (Throwable)e);
            throw new OptimizeRuntimeException("Was not able to retrieve reports!", (Throwable)e);
        }
    }

    private <T> MgetResponse<T> performMultiGetReportRequest(String reportId, Class<T> clas) {
        MgetResponse multiGetItemResponses;
        MgetRequest.Builder request = new MgetRequest.Builder();
        request.docs(MultiGetOperation.of(m -> new OptimizeMultiGetOperationBuilderES().optimizeIndex(this.esClient, "single-process-report").id(reportId)), new MultiGetOperation[]{MultiGetOperation.of(m -> new OptimizeMultiGetOperationBuilderES().optimizeIndex(this.esClient, "single-decision-report").id(reportId)), MultiGetOperation.of(m -> new OptimizeMultiGetOperationBuilderES().optimizeIndex(this.esClient, "combined-report").id(reportId))});
        try {
            multiGetItemResponses = this.esClient.mget(request.build(), clas);
        }
        catch (IOException e) {
            String reason = String.format("Could not fetch report with id [%s]", reportId);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        return multiGetItemResponses;
    }
}

