/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.reader;

import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationBuilders;
import co.elastic.clients.elasticsearch._types.aggregations.StringTermsAggregate;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeSearchRequestBuilderES;
import io.camunda.optimize.service.db.reader.DefinitionInstanceReader;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.ExceptionUtil;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class DefinitionInstanceReaderES
extends DefinitionInstanceReader {
    private static final Logger LOG = LoggerFactory.getLogger(DefinitionInstanceReaderES.class);
    private final OptimizeElasticsearchClient esClient;

    public DefinitionInstanceReaderES(OptimizeElasticsearchClient esClient) {
        this.esClient = esClient;
    }

    @Override
    public Set<String> getAllExistingDefinitionKeys(DefinitionType type, Set<String> instanceIds) {
        SearchResponse response;
        String defKeyAggName = "definitionKeyAggregation";
        SearchRequest searchRequest = OptimizeSearchRequestBuilderES.of(b -> b.optimizeIndex(this.esClient, new String[]{this.resolveIndexMultiAliasForType(type)}).source(s -> s.fetch(Boolean.valueOf(false))).size(Integer.valueOf(0)).query(q -> q.bool(bb -> {
            if (CollectionUtils.isEmpty((Collection)instanceIds)) {
                bb.must(m -> m.matchAll(a -> a));
            } else {
                bb.filter(f -> f.terms(t -> t.field(this.resolveInstanceIdFieldForType(type)).terms(tt -> tt.value(instanceIds.stream().map(FieldValue::of).toList()))));
            }
            return bb;
        })).aggregations(Map.of("definitionKeyAggregation", AggregationBuilders.terms(t -> t.field(this.resolveDefinitionKeyFieldForType(type)).size(Integer.valueOf(10000))))));
        try {
            response = this.esClient.search(searchRequest, Object.class);
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException(String.format("Was not able to retrieve definition keys for instances of type %s", type), (Throwable)e);
        }
        catch (ElasticsearchException e) {
            if (ExceptionUtil.isInstanceIndexNotFoundException((DefinitionType)type, (RuntimeException)((Object)e))) {
                LOG.info("Was not able to retrieve definition keys for instances because no {} instance indices exist. Returning empty set.", (Object)type);
                return Collections.emptySet();
            }
            throw e;
        }
        StringTermsAggregate definitionKeyTerms = ((Aggregate)response.aggregations().get("definitionKeyAggregation")).sterms();
        return definitionKeyTerms.buckets().array().stream().map(r -> r.key().stringValue()).collect(Collectors.toSet());
    }
}

