/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.reader;

import co.elastic.clients.elasticsearch._types.query_dsl.ChildScoreMode;
import co.elastic.clients.elasticsearch.core.CountRequest;
import co.elastic.clients.elasticsearch.core.GetRequest;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.query.dashboard.DashboardDefinitionRestDto;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeCountRequestBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeGetRequestBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeSearchRequestBuilderES;
import io.camunda.optimize.service.db.es.reader.ElasticsearchReaderUtil;
import io.camunda.optimize.service.db.reader.DashboardReader;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class DashboardReaderES
implements DashboardReader {
    private static final Logger LOG = LoggerFactory.getLogger(DashboardReaderES.class);
    private final OptimizeElasticsearchClient esClient;
    private final ObjectMapper objectMapper;

    public DashboardReaderES(OptimizeElasticsearchClient esClient, ObjectMapper objectMapper) {
        this.esClient = esClient;
        this.objectMapper = objectMapper;
    }

    @Override
    public long getDashboardCount() {
        CountRequest countRequest = OptimizeCountRequestBuilderES.of(b -> b.optimizeIndex(this.esClient, "dashboard").query(q -> q.term(t -> t.field("managementDashboard").value(false))));
        try {
            return this.esClient.count(countRequest).count();
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException("Was not able to retrieve dashboard count!", (Throwable)e);
        }
    }

    @Override
    public Optional<DashboardDefinitionRestDto> getDashboard(String dashboardId) {
        LOG.debug("Fetching dashboard with id [{}]", (Object)dashboardId);
        GetRequest getRequest = OptimizeGetRequestBuilderES.of(b -> b.optimizeIndex(this.esClient, "dashboard").id(dashboardId));
        try {
            return Optional.ofNullable((DashboardDefinitionRestDto)this.esClient.get(getRequest, DashboardDefinitionRestDto.class).source());
        }
        catch (IOException e) {
            String reason = String.format("Could not fetch dashboard with id [%s]", dashboardId);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
    }

    @Override
    public List<DashboardDefinitionRestDto> getDashboards(Set<String> dashboardIds) {
        SearchResponse searchResponse;
        LOG.debug("Fetching dashboards with IDs {}", dashboardIds);
        String[] dashboardIdsAsArray = dashboardIds.toArray(new String[0]);
        SearchRequest searchRequest = OptimizeSearchRequestBuilderES.of(b -> b.optimizeIndex(this.esClient, new String[]{"dashboard"}).size(Integer.valueOf(1000)).query(q -> q.ids(i -> i.values(Arrays.stream(dashboardIdsAsArray).toList()))));
        try {
            searchResponse = this.esClient.search(searchRequest, DashboardDefinitionRestDto.class);
        }
        catch (IOException e) {
            String reason = String.format("Was not able to fetch dashboards for IDs [%s]", dashboardIds);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        return ElasticsearchReaderUtil.mapHits(searchResponse.hits(), DashboardDefinitionRestDto.class, this.objectMapper);
    }

    @Override
    public List<DashboardDefinitionRestDto> getDashboardsForCollection(String collectionId) {
        SearchResponse searchResponse;
        LOG.debug("Fetching dashboards using collection with id {}", (Object)collectionId);
        SearchRequest searchRequest = OptimizeSearchRequestBuilderES.of(b -> b.optimizeIndex(this.esClient, new String[]{"dashboard"}).query(q -> q.term(t -> t.field("collectionId").value(collectionId))).size(Integer.valueOf(1000)));
        try {
            searchResponse = this.esClient.search(searchRequest, DashboardDefinitionRestDto.class);
        }
        catch (IOException e) {
            String reason = String.format("Was not able to fetch dashboards for collection with id [%s]", collectionId);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        return ElasticsearchReaderUtil.mapHits(searchResponse.hits(), DashboardDefinitionRestDto.class, this.objectMapper);
    }

    @Override
    public List<DashboardDefinitionRestDto> getDashboardsForReport(String reportId) {
        SearchResponse searchResponse;
        LOG.debug("Fetching dashboards using report with id {}", (Object)reportId);
        SearchRequest searchRequest = OptimizeSearchRequestBuilderES.of(b -> b.optimizeIndex(this.esClient, new String[]{"dashboard"}).size(Integer.valueOf(1000)).query(q -> q.bool(bb -> bb.filter(f -> f.nested(n -> n.path("tiles").scoreMode(ChildScoreMode.None).query(qq -> qq.term(tt -> tt.field("tiles.id").value(reportId))))))));
        try {
            searchResponse = this.esClient.search(searchRequest, DashboardDefinitionRestDto.class);
        }
        catch (IOException e) {
            String reason = String.format("Was not able to fetch dashboards for report with id [%s]", reportId);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        return ElasticsearchReaderUtil.mapHits(searchResponse.hits(), DashboardDefinitionRestDto.class, this.objectMapper);
    }
}

