/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.reader;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.query_dsl.MatchAllQuery;
import co.elastic.clients.elasticsearch.core.CountRequest;
import co.elastic.clients.elasticsearch.core.GetRequest;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.query.alert.AlertDefinitionDto;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeCountRequestBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeGetRequestBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeSearchRequestBuilderES;
import io.camunda.optimize.service.db.es.reader.ElasticsearchReaderUtil;
import io.camunda.optimize.service.db.reader.AlertReader;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class AlertReaderES
implements AlertReader {
    private static final Logger LOG = LoggerFactory.getLogger(AlertReaderES.class);
    private final OptimizeElasticsearchClient esClient;
    private final ConfigurationService configurationService;
    private final ObjectMapper objectMapper;

    public AlertReaderES(OptimizeElasticsearchClient esClient, ConfigurationService configurationService, ObjectMapper objectMapper) {
        this.esClient = esClient;
        this.configurationService = configurationService;
        this.objectMapper = objectMapper;
    }

    @Override
    public long getAlertCount() {
        CountRequest countRequest = OptimizeCountRequestBuilderES.of(b -> b.optimizeIndex(this.esClient, "alert"));
        try {
            return this.esClient.count(countRequest).count();
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException("Was not able to retrieve alert count!", (Throwable)e);
        }
    }

    @Override
    public List<AlertDefinitionDto> getStoredAlerts() {
        SearchResponse scrollResp;
        LOG.debug("getting all stored alerts");
        SearchRequest searchRequest = OptimizeSearchRequestBuilderES.of(b -> b.optimizeIndex(this.esClient, new String[]{"alert"}).size(Integer.valueOf(1000)).query(q -> q.matchAll(MatchAllQuery.of(m -> m))).scroll(Time.of(t -> t.time(this.configurationService.getElasticSearchConfiguration().getScrollTimeoutInSeconds() + "s"))));
        try {
            scrollResp = this.esClient.search(searchRequest, AlertDefinitionDto.class);
        }
        catch (IOException e) {
            LOG.error("Was not able to retrieve stored alerts!", (Throwable)e);
            throw new OptimizeRuntimeException("Was not able to retrieve stored alerts!", (Throwable)e);
        }
        return ElasticsearchReaderUtil.retrieveAllScrollResults(scrollResp, AlertDefinitionDto.class, this.objectMapper, this.esClient, (Integer)this.configurationService.getElasticSearchConfiguration().getScrollTimeoutInSeconds());
    }

    @Override
    public Optional<AlertDefinitionDto> getAlert(String alertId) {
        LOG.debug("Fetching alert with id [{}]", (Object)alertId);
        GetRequest getRequest = OptimizeGetRequestBuilderES.of(b -> b.optimizeIndex(this.esClient, "alert").id(alertId));
        try {
            return Optional.ofNullable((AlertDefinitionDto)this.esClient.get(getRequest, AlertDefinitionDto.class).source());
        }
        catch (IOException e) {
            String reason = String.format("Could not fetch alert with id [%s]", alertId);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
    }

    @Override
    public List<AlertDefinitionDto> getAlertsForReport(String reportId) {
        SearchResponse searchResponse;
        LOG.debug("Fetching first {} alerts using report with id {}", (Object)1000, (Object)reportId);
        SearchRequest searchRequest = OptimizeSearchRequestBuilderES.of(b -> b.optimizeIndex(this.esClient, new String[]{"alert"}).query(q -> q.term(t -> t.field("reportId").value(FieldValue.of((String)reportId)))).size(Integer.valueOf(1000)));
        try {
            searchResponse = this.esClient.search(searchRequest, AlertDefinitionDto.class);
        }
        catch (IOException e) {
            String reason = String.format("Was not able to fetch alerts for report with id [%s]", reportId);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        return ElasticsearchReaderUtil.mapHits(searchResponse.hits(), AlertDefinitionDto.class, this.objectMapper);
    }

    @Override
    public List<AlertDefinitionDto> getAlertsForReports(List<String> reportIds) {
        SearchResponse searchResponse;
        LOG.debug("Fetching first {} alerts using reports with ids {}", (Object)1000, reportIds);
        SearchRequest searchRequest = OptimizeSearchRequestBuilderES.of(b -> b.optimizeIndex(this.esClient, new String[]{"alert"}).query(q -> q.terms(t -> t.field("reportId").terms(tt -> tt.value(reportIds.stream().map(FieldValue::of).toList())))).size(Integer.valueOf(1000)));
        try {
            searchResponse = this.esClient.search(searchRequest, AlertDefinitionDto.class);
        }
        catch (IOException e) {
            String reason = String.format("Was not able to fetch alerts for reports with ids [%s]", reportIds);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        return ElasticsearchReaderUtil.mapHits(searchResponse.hits(), AlertDefinitionDto.class, this.objectMapper);
    }

    private void logError(String alertId) {
        LOG.error("Was not able to retrieve alert with id [{}] from Elasticsearch.", (Object)alertId);
    }
}

