/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.filter;

import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.ChildScoreMode;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.operator.MembershipFilterOperator;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.data.ExecutedFlowNodeFilterDataDto;
import io.camunda.optimize.service.db.es.filter.QueryFilterES;
import io.camunda.optimize.service.db.filter.FilterContext;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class ExecutedFlowNodeQueryFilterES
implements QueryFilterES<ExecutedFlowNodeFilterDataDto> {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutedFlowNodeQueryFilterES.class);

    @Override
    public void addFilters(BoolQuery.Builder query, List<ExecutedFlowNodeFilterDataDto> flowNodeFilter, FilterContext filterContext) {
        query.filter(flowNodeFilter.stream().map(this::createFilterQueryBuilder).toList());
    }

    private Query createFilterQueryBuilder(ExecutedFlowNodeFilterDataDto flowNodeFilter) {
        BoolQuery.Builder boolQueryBuilder = new BoolQuery.Builder();
        if (MembershipFilterOperator.IN == flowNodeFilter.getOperator()) {
            for (String value : flowNodeFilter.getValues()) {
                boolQueryBuilder.should(s -> s.nested(n -> n.path("flowNodeInstances").query(q -> q.term(t -> t.field(this.nestedFlowNodeIdFieldLabel()).value(value))).scoreMode(ChildScoreMode.None)));
            }
        } else if (MembershipFilterOperator.NOT_IN == flowNodeFilter.getOperator()) {
            for (String value : flowNodeFilter.getValues()) {
                boolQueryBuilder.mustNot(s -> s.nested(n -> n.path("flowNodeInstances").query(q -> q.term(t -> t.field(this.nestedFlowNodeIdFieldLabel()).value(value))).scoreMode(ChildScoreMode.None)));
            }
        } else {
            LOG.error("Could not filter for flow nodes. Operator [{}] is not allowed! Use either [in] or [not in]", (Object)flowNodeFilter.getOperator());
        }
        return Query.of(b -> b.bool(boolQueryBuilder.build()));
    }

    private String nestedFlowNodeIdFieldLabel() {
        return "flowNodeInstances.flowNodeId";
    }
}

