/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.filter;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.ChildScoreMode;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.json.JsonData;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.FilterOperator;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.OperatorMultipleValuesFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.DateFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.BooleanVariableFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.DateVariableFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.OperatorMultipleValuesVariableFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.StringVariableFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.VariableFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.data.BooleanVariableFilterSubDataDto;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.service.db.es.filter.AbstractVariableQueryFilterES;
import io.camunda.optimize.service.db.es.filter.util.DateFilterQueryUtilES;
import io.camunda.optimize.service.db.es.util.ProcessVariableHelperES;
import io.camunda.optimize.service.db.filter.util.OperatorMultipleValuesVariableFilterDataDtoUtil;
import io.camunda.optimize.service.db.util.ProcessVariableHelper;
import io.camunda.optimize.service.util.ValidationHelper;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractProcessVariableQueryFilterES
extends AbstractVariableQueryFilterES {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractProcessVariableQueryFilterES.class);

    protected Query.Builder createFilterQueryBuilder(VariableFilterDataDto<?> dto, ZoneId timezone) {
        ValidationHelper.ensureNotNull("Variable filter data", dto.getData());
        Query.Builder queryBuilder = new Query.Builder();
        switch (dto.getType()) {
            case STRING: {
                StringVariableFilterDataDto stringVarDto = (StringVariableFilterDataDto)dto;
                queryBuilder = this.createStringQueryBuilder(stringVarDto);
                break;
            }
            case INTEGER: 
            case DOUBLE: 
            case SHORT: 
            case LONG: {
                OperatorMultipleValuesVariableFilterDataDto numericVarDto = (OperatorMultipleValuesVariableFilterDataDto)dto;
                queryBuilder = this.createNumericQueryBuilder(numericVarDto);
                break;
            }
            case DATE: {
                DateVariableFilterDataDto dateVarDto = (DateVariableFilterDataDto)dto;
                queryBuilder = this.createDateQueryBuilder(dateVarDto, timezone);
                break;
            }
            case BOOLEAN: {
                BooleanVariableFilterDataDto booleanVarDto = (BooleanVariableFilterDataDto)dto;
                queryBuilder = this.createBooleanQueryBuilder(booleanVarDto);
                break;
            }
            default: {
                LOG.warn("Could not filter for variables! Type [{}] is not supported for variable filters. Ignoring filter.", (Object)dto.getType());
            }
        }
        return queryBuilder;
    }

    @Override
    protected Query.Builder createContainsOneOfTheGivenStringsQueryBuilder(StringVariableFilterDataDto dto) {
        Query.Builder containOneOfTheGivenStrings = this.createContainsOneOfTheGivenStringsQueryBuilder(dto.getName(), ((OperatorMultipleValuesFilterDataDto)dto.getData()).getValues());
        if (FilterOperator.NOT_CONTAINS.equals((Object)((OperatorMultipleValuesFilterDataDto)dto.getData()).getOperator())) {
            Query.Builder builder = new Query.Builder();
            builder.bool(b -> b.mustNot(containOneOfTheGivenStrings.build(), new Query[0]));
            return builder;
        }
        return containOneOfTheGivenStrings;
    }

    @Override
    protected Query.Builder createContainsOneOfTheGivenStringsQueryBuilder(String variableName, List<String> values) {
        Query.Builder builder = new Query.Builder();
        BoolQuery.Builder variableFilterBuilder = new BoolQuery.Builder().minimumShouldMatch("1");
        values.stream().filter(Objects::nonNull).forEach(stringVal -> variableFilterBuilder.should(this.createContainsGivenStringQuery(variableName, (String)stringVal).build(), new Query[0]));
        boolean hasNullValues = values.stream().anyMatch(Objects::isNull);
        if (hasNullValues) {
            variableFilterBuilder.should(s -> s.bool(this.createFilterForUndefinedOrNullQueryBuilder(variableName, VariableType.STRING).build()));
        }
        builder.bool(variableFilterBuilder.build());
        return builder;
    }

    @Override
    protected Query.Builder createContainsGivenStringQuery(String variableName, String valueToContain) {
        Query.Builder queryBuilder = new Query.Builder();
        BoolQuery.Builder containsVariableString = new BoolQuery.Builder();
        containsVariableString.must(m -> m.term(t -> t.field(ProcessVariableHelper.getNestedVariableNameField()).value(variableName))).must(m -> m.term(t -> t.field(ProcessVariableHelper.getNestedVariableTypeField()).value(VariableType.STRING.getId())));
        containsVariableString.must(AbstractProcessVariableQueryFilterES.getBuilder(valueToContain).build(), new Query[0]);
        queryBuilder.nested(n -> n.path("variables").query(q -> q.bool(containsVariableString.build())).scoreMode(ChildScoreMode.None));
        return queryBuilder;
    }

    private static Query.Builder getBuilder(String valueToContain) {
        String lowerCaseValue = valueToContain.toLowerCase(Locale.ENGLISH);
        Query.Builder filter = new Query.Builder();
        if (lowerCaseValue.length() > 10) {
            filter.wildcard(w -> w.field(ProcessVariableHelper.getValueSearchField("lowercaseField")).wildcard(ProcessVariableHelper.buildWildcardQuery(lowerCaseValue)));
        } else {
            filter.term(t -> t.field(ProcessVariableHelper.getValueSearchField("nGramField")).value(lowerCaseValue));
        }
        return filter;
    }

    @Override
    protected Query.Builder createEqualsOneOrMoreValuesQueryBuilder(OperatorMultipleValuesVariableFilterDataDto dto) {
        Query.Builder variableFilterBuilder = this.createEqualsOneOrMoreValuesFilterQuery(dto.getName(), dto.getType(), ((OperatorMultipleValuesFilterDataDto)dto.getData()).getValues());
        if (FilterOperator.NOT_IN.equals((Object)((OperatorMultipleValuesFilterDataDto)dto.getData()).getOperator())) {
            Query.Builder builder = new Query.Builder();
            builder.bool(b -> b.mustNot(variableFilterBuilder.build(), new Query[0]));
            return builder;
        }
        return variableFilterBuilder;
    }

    @Override
    protected Query.Builder createBooleanQueryBuilder(BooleanVariableFilterDataDto dto) {
        ValidationHelper.ensureCollectionNotEmpty("boolean filter value", ((BooleanVariableFilterSubDataDto)dto.getData()).getValues());
        return this.createEqualsOneOrMoreValuesFilterQuery(dto.getName(), dto.getType(), ((BooleanVariableFilterSubDataDto)dto.getData()).getValues());
    }

    private Query.Builder createEqualsOneOrMoreValuesFilterQuery(String variableName, VariableType variableType, List<?> values) {
        boolean hasNullValues;
        Query.Builder builder = new Query.Builder();
        BoolQuery.Builder variableFilterBuilder = new BoolQuery.Builder().minimumShouldMatch("1");
        String nestedVariableNameFieldLabel = ProcessVariableHelper.getNestedVariableNameField();
        String nestedVariableValueFieldLabel = this.getVariableValueFieldForType(variableType);
        List<Object> nonNullValues = values.stream().filter(Objects::nonNull).toList();
        if (!nonNullValues.isEmpty()) {
            variableFilterBuilder.should(s -> s.nested(n -> n.path("variables").query(q -> q.bool(b -> b.must(m -> m.term(t -> t.field(nestedVariableNameFieldLabel).value(variableName))).must(m -> m.term(t -> t.field(ProcessVariableHelper.getNestedVariableTypeField()).value(variableType.getId()))).must(m -> m.terms(t -> t.field(nestedVariableValueFieldLabel).terms(tt -> tt.value(nonNullValues.stream().map(FieldValue::of).toList()))))))));
        }
        boolean bl = hasNullValues = nonNullValues.size() < values.size();
        if (hasNullValues) {
            variableFilterBuilder.should(s -> s.bool(this.createFilterForUndefinedOrNullQueryBuilder(variableName, variableType).build()));
        }
        builder.bool(variableFilterBuilder.build());
        return builder;
    }

    @Override
    protected Query.Builder createNumericQueryBuilder(OperatorMultipleValuesVariableFilterDataDto dto) {
        Query.Builder builder = new Query.Builder();
        OperatorMultipleValuesVariableFilterDataDtoUtil.validateMultipleValuesFilterDataDto(dto);
        String nestedVariableValueFieldLabel = this.getVariableValueFieldForType(dto.getType());
        OperatorMultipleValuesFilterDataDto data = (OperatorMultipleValuesFilterDataDto)dto.getData();
        BoolQuery.Builder boolQueryBuilder = new BoolQuery.Builder();
        boolQueryBuilder.must(m -> m.term(t -> t.field(ProcessVariableHelper.getNestedVariableNameField()).value(dto.getName()))).must(m -> m.term(t -> t.field(ProcessVariableHelper.getNestedVariableTypeField()).value(dto.getType().getId())));
        Object value = OperatorMultipleValuesVariableFilterDataDtoUtil.retrieveValue(dto);
        switch (data.getOperator()) {
            case IN: 
            case NOT_IN: {
                return this.createEqualsOneOrMoreValuesQueryBuilder(dto);
            }
            case LESS_THAN: {
                builder.nested(n -> n.path("variables").query(qq -> qq.bool(boolQueryBuilder.must(m -> m.range(r -> r.field(nestedVariableValueFieldLabel).lt(JsonData.of((Object)value)))).build())));
                break;
            }
            case GREATER_THAN: {
                builder.nested(n -> n.path("variables").query(qq -> qq.bool(boolQueryBuilder.must(m -> m.range(r -> r.field(nestedVariableValueFieldLabel).gt(JsonData.of((Object)value)))).build())));
                break;
            }
            case LESS_THAN_EQUALS: {
                builder.nested(n -> n.path("variables").query(qq -> qq.bool(boolQueryBuilder.must(m -> m.range(r -> r.field(nestedVariableValueFieldLabel).lte(JsonData.of((Object)value)))).build())));
                break;
            }
            case GREATER_THAN_EQUALS: {
                builder.nested(n -> n.path("variables").query(qq -> qq.bool(boolQueryBuilder.must(m -> m.range(r -> r.field(nestedVariableValueFieldLabel).gte(JsonData.of((Object)value)))).build())));
                break;
            }
            default: {
                builder.nested(n -> n.path("variables").query(qq -> qq.bool(boolQueryBuilder.build())));
                LOG.warn("Could not filter for variables! Operator [{}] is not supported for type [{}]. Ignoring filter.", (Object)data.getOperator(), (Object)dto.getType());
            }
        }
        return builder;
    }

    @Override
    protected Query.Builder createDateQueryBuilder(DateVariableFilterDataDto dto, ZoneId timezone) {
        Query.Builder dateFilterBuilder = new Query.Builder();
        dateFilterBuilder.bool(bool -> {
            if (((DateFilterDataDto)dto.getData()).isIncludeUndefined()) {
                bool.should(s -> s.bool(this.createFilterForUndefinedOrNullQueryBuilder(dto.getName(), dto.getType()).build()));
            } else if (((DateFilterDataDto)dto.getData()).isExcludeUndefined()) {
                bool.should(s -> s.bool(this.createExcludeUndefinedOrNullQueryBuilder(dto.getName(), dto.getType()).build()));
            }
            BoolQuery.Builder dateValueFilterQuery = new BoolQuery.Builder();
            dateValueFilterQuery.must(m -> m.terms(t -> t.field(ProcessVariableHelper.getNestedVariableNameField()).terms(tt -> tt.value(List.of(FieldValue.of((String)dto.getName())))))).must(m -> m.term(t -> t.field(ProcessVariableHelper.getNestedVariableTypeField()).value(dto.getType().getId())));
            DateFilterQueryUtilES.addFilters(dateValueFilterQuery, Collections.singletonList((DateFilterDataDto)dto.getData()), this.getVariableValueFieldForType(dto.getType()), timezone);
            BoolQuery build = dateValueFilterQuery.build();
            if (!build.filter().isEmpty()) {
                bool.should(s -> s.nested(n -> n.path("variables").query(q -> q.bool(build)).scoreMode(ChildScoreMode.None)));
            }
            return bool;
        });
        return dateFilterBuilder;
    }

    private String getVariableValueFieldForType(VariableType type) {
        return ProcessVariableHelper.getNestedVariableValueFieldForType(type);
    }

    private BoolQuery.Builder createFilterForUndefinedOrNullQueryBuilder(String variableName, VariableType variableType) {
        return ProcessVariableHelperES.createFilterForUndefinedOrNullQueryBuilder(variableName, variableType);
    }

    private BoolQuery.Builder createExcludeUndefinedOrNullQueryBuilder(String variableName, VariableType variableType) {
        return ProcessVariableHelperES.createExcludeUndefinedOrNullQueryFilterBuilder(variableName, variableType);
    }
}

