/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es;

import co.elastic.clients.json.jackson.JacksonJsonProvider;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClientFactory;
import io.camunda.optimize.service.db.es.schema.ElasticSearchSchemaManager;
import io.camunda.optimize.service.db.schema.OptimizeIndexNameService;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.BackoffCalculator;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import io.camunda.optimize.service.util.mapper.ObjectMapperFactory;
import io.camunda.search.connect.plugin.PluginRepository;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={ElasticSearchCondition.class})
public class OptimizeElasticsearchClientConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(OptimizeElasticsearchClientConfiguration.class);
    private final ConfigurationService configurationService;
    private final OptimizeIndexNameService optimizeIndexNameService;
    private final ElasticSearchSchemaManager elasticSearchSchemaManager;
    private final PluginRepository pluginRepository = new PluginRepository();

    public OptimizeElasticsearchClientConfiguration(ConfigurationService configurationService, OptimizeIndexNameService optimizeIndexNameService, ElasticSearchSchemaManager elasticSearchSchemaManager) {
        this.configurationService = configurationService;
        this.optimizeIndexNameService = optimizeIndexNameService;
        this.elasticSearchSchemaManager = elasticSearchSchemaManager;
    }

    @Bean
    public OptimizeElasticsearchClient optimizeElasticsearchClient(BackoffCalculator backoffCalculator) {
        return this.createOptimizeElasticsearchClient(backoffCalculator);
    }

    @Bean
    public JacksonJsonProvider jacksonJsonProvider() {
        return new JacksonJsonProvider(new JacksonJsonpMapper(ObjectMapperFactory.OPTIMIZE_MAPPER));
    }

    public OptimizeElasticsearchClient createOptimizeElasticsearchClient(BackoffCalculator backoffCalculator) {
        try {
            return OptimizeElasticsearchClientFactory.create(this.configurationService, this.optimizeIndexNameService, this.elasticSearchSchemaManager, backoffCalculator, this.pluginRepository);
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
    }
}

