/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db;

import io.camunda.optimize.dto.optimize.DecisionDefinitionOptimizeDto;
import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.service.db.reader.DecisionDefinitionReader;
import io.camunda.optimize.service.db.reader.DefinitionReader;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DecisionDefinitionReaderImpl
implements DecisionDefinitionReader {
    private static final Logger LOG = LoggerFactory.getLogger(DecisionDefinitionReaderImpl.class);
    private final DefinitionReader definitionReader;

    public DecisionDefinitionReaderImpl(DefinitionReader definitionReader) {
        this.definitionReader = definitionReader;
    }

    @Override
    public Optional<DecisionDefinitionOptimizeDto> getDecisionDefinition(String decisionDefinitionKey, List<String> decisionDefinitionVersions, List<String> tenantIds) {
        return this.definitionReader.getFirstFullyImportedDefinitionFromTenantsIfAvailable(DefinitionType.DECISION, decisionDefinitionKey, decisionDefinitionVersions, tenantIds);
    }

    @Override
    public List<DecisionDefinitionOptimizeDto> getAllDecisionDefinitions() {
        return this.definitionReader.getDefinitions(DefinitionType.DECISION, false, false, true);
    }

    @Override
    public String getLatestVersionToKey(String key) {
        return this.definitionReader.getLatestVersionToKey(DefinitionType.DECISION, key);
    }
}

