/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.collection;

import io.camunda.optimize.dto.optimize.IdentityDto;
import io.camunda.optimize.dto.optimize.IdentityWithMetadataResponseDto;
import io.camunda.optimize.dto.optimize.UserDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionDataDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionDefinitionDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionRoleRequestDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionRoleResponseDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionRoleUpdateRequestDto;
import io.camunda.optimize.dto.optimize.rest.AuthorizedCollectionDefinitionDto;
import io.camunda.optimize.rest.exceptions.NotFoundException;
import io.camunda.optimize.service.db.reader.CollectionReader;
import io.camunda.optimize.service.db.writer.CollectionWriter;
import io.camunda.optimize.service.exceptions.OptimizeUserOrGroupIdNotFoundException;
import io.camunda.optimize.service.exceptions.OptimizeValidationException;
import io.camunda.optimize.service.exceptions.conflict.OptimizeCollectionConflictException;
import io.camunda.optimize.service.identity.AbstractIdentityService;
import io.camunda.optimize.service.security.AuthorizedCollectionService;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CollectionRoleService {
    private static final Logger LOG = LoggerFactory.getLogger(CollectionRoleService.class);
    private final AuthorizedCollectionService authorizedCollectionService;
    private final CollectionWriter collectionWriter;
    private final CollectionReader collectionReader;
    private final AbstractIdentityService identityService;

    public CollectionRoleService(AuthorizedCollectionService authorizedCollectionService, CollectionWriter collectionWriter, CollectionReader collectionReader, AbstractIdentityService identityService) {
        this.authorizedCollectionService = authorizedCollectionService;
        this.collectionWriter = collectionWriter;
        this.collectionReader = collectionReader;
        this.identityService = identityService;
    }

    public void addRolesToCollection(String userId, String collectionId, List<CollectionRoleRequestDto> rolesToAdd) {
        this.authorizedCollectionService.getAuthorizedCollectionAndVerifyUserAuthorizedToManageOrFail(userId, collectionId);
        List<CollectionRoleRequestDto> resolvedRolesToAdd = this.validateAndResolveIdentities(userId, rolesToAdd);
        this.collectionWriter.addRoleToCollection(collectionId, resolvedRolesToAdd, userId);
    }

    private List<CollectionRoleRequestDto> validateAndResolveIdentities(String userId, List<CollectionRoleRequestDto> rolesToAdd) {
        return rolesToAdd.stream().map(roleData -> {
            this.enrichWithIdentityIfMissing((CollectionRoleRequestDto)roleData);
            this.validateIdentity((CollectionRoleRequestDto)roleData);
            this.identityService.validateUserAuthorizedToAccessRoleOrFail(userId, roleData.getIdentity());
            return roleData;
        }).collect(Collectors.toList());
    }

    private void enrichWithIdentityIfMissing(CollectionRoleRequestDto role) {
        IdentityDto requestIdentityDto = role.getIdentity();
        if (requestIdentityDto.getType() == null) {
            IdentityDto resolvedIdentityDto = this.identityService.getIdentityWithMetadataForId(requestIdentityDto.getId()).orElseThrow(() -> new OptimizeUserOrGroupIdNotFoundException(String.format("No user or group with ID %s exists in Optimize.", requestIdentityDto.getId()))).toIdentityDto();
            role.setIdentity(resolvedIdentityDto);
        }
    }

    private void validateIdentity(CollectionRoleRequestDto role) {
        if (!this.identityService.doesIdentityExist(role.getIdentity())) {
            throw new OptimizeValidationException(String.format("%s with id %s does not exist in Optimize", role.getIdentity().getType(), role.getIdentity().getId()));
        }
    }

    public void updateRoleOfCollection(String userId, String collectionId, String roleEntryId, CollectionRoleUpdateRequestDto roleUpdateDto) {
        this.collectionWriter.updateRoleInCollection(collectionId, roleEntryId, roleUpdateDto, userId);
    }

    public void removeRoleFromCollectionUnlessIsLastManager(String userId, String collectionId, String roleEntryId) {
        this.collectionWriter.removeRoleFromCollectionUnlessIsLastManager(collectionId, roleEntryId, userId);
    }

    public void removeRolesFromCollection(String userId, String collectionId, List<String> roleEntryIds) {
        this.verifyCollectionExists(collectionId);
        roleEntryIds.forEach(roleEntryId -> this.authorizedCollectionService.verifyUserAuthorizedToEditCollectionRole(userId, collectionId, (String)roleEntryId));
        for (String roleId : roleEntryIds) {
            try {
                this.collectionWriter.removeRoleFromCollectionUnlessIsLastManager(collectionId, roleId, userId);
            }
            catch (NotFoundException e) {
                LOG.debug("Could not delete role with id {}. The role is already deleted.", (Object)roleId);
            }
            catch (OptimizeCollectionConflictException e) {
                LOG.debug("Could not delete role with id {}, because the user with that id is a manager.", (Object)roleId);
            }
        }
    }

    private void verifyCollectionExists(String collectionId) {
        Optional<CollectionDefinitionDto> collectionDefinition = this.collectionReader.getCollection(collectionId);
        if (collectionDefinition.isEmpty()) {
            LOG.error("Was not able to retrieve collection with id [{}] from the database.", (Object)collectionId);
            throw new NotFoundException("Collection does not exist! Tried to retrieve collection with id " + collectionId);
        }
    }

    public List<CollectionRoleResponseDto> getAllRolesOfCollectionSorted(String userId, String collectionId) {
        AuthorizedCollectionDefinitionDto authCollectionDto = this.authorizedCollectionService.getAuthorizedCollectionDefinitionOrFail(userId, collectionId);
        return ((CollectionDataDto)authCollectionDto.getDefinitionDto().getData()).getRoles().stream().filter(role -> this.identityService.isUserAuthorizedToAccessIdentity(userId, role.getIdentity())).map(roleDto -> this.identityService.getIdentityWithMetadataForId(roleDto.getIdentity().getId()).map(identity -> CollectionRoleResponseDto.from((CollectionRoleRequestDto)roleDto, (IdentityWithMetadataResponseDto)identity)).orElseGet(() -> {
            LOG.info("Identity with id {} is present in roles but does not exist anymore.", (Object)roleDto.getId());
            return CollectionRoleResponseDto.from((CollectionRoleRequestDto)roleDto, (IdentityWithMetadataResponseDto)new UserDto(roleDto.getIdentity().getId()));
        })).sorted().toList();
    }
}

