/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.cleanup;

import io.camunda.optimize.dto.optimize.DefinitionOptimizeResponseDto;
import io.camunda.optimize.service.cleanup.CleanupService;
import io.camunda.optimize.service.db.reader.DecisionDefinitionReader;
import io.camunda.optimize.service.db.writer.DecisionInstanceWriter;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.cleanup.CleanupConfiguration;
import io.camunda.optimize.service.util.configuration.cleanup.DecisionDefinitionCleanupConfiguration;
import java.time.OffsetDateTime;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EngineDataDecisionCleanupService
extends CleanupService {
    private static final Logger LOG = LoggerFactory.getLogger(EngineDataDecisionCleanupService.class);
    private final ConfigurationService configurationService;
    private final DecisionDefinitionReader decisionDefinitionReader;
    private final DecisionInstanceWriter decisionInstanceWriter;

    public EngineDataDecisionCleanupService(ConfigurationService configurationService, DecisionDefinitionReader decisionDefinitionReader, DecisionInstanceWriter decisionInstanceWriter) {
        this.configurationService = configurationService;
        this.decisionDefinitionReader = decisionDefinitionReader;
        this.decisionInstanceWriter = decisionInstanceWriter;
    }

    @Override
    public boolean isEnabled() {
        return this.getCleanupConfiguration().getDecisionCleanupConfiguration().isEnabled();
    }

    @Override
    public void doCleanup(OffsetDateTime startTime) {
        Set<String> allOptimizeProcessDefinitionKeys = this.getAllOptimizeDecisionDefinitionKeys();
        this.verifyConfiguredKeysAreKnownDefinitionKeys(allOptimizeProcessDefinitionKeys, this.getCleanupConfiguration().getDecisionCleanupConfiguration().getAllDecisionSpecificConfigurationKeys());
        int i = 1;
        for (String currentProcessDefinitionKey : allOptimizeProcessDefinitionKeys) {
            LOG.info("Decision History Cleanup step {}/{}", (Object)i, (Object)allOptimizeProcessDefinitionKeys.size());
            this.performCleanupForDecisionKey(startTime, currentProcessDefinitionKey);
            ++i;
        }
    }

    private void performCleanupForDecisionKey(OffsetDateTime startTime, String decisionDefinitionKey) {
        DecisionDefinitionCleanupConfiguration cleanupConfigurationForKey = this.getCleanupConfiguration().getDecisionDefinitionCleanupConfigurationForKey(decisionDefinitionKey);
        LOG.info("Performing cleanup on decision instances for decisionDefinitionKey: {}, with ttl: {}", (Object)decisionDefinitionKey, (Object)cleanupConfigurationForKey.getTtl());
        OffsetDateTime endDateFilter = startTime.minus(cleanupConfigurationForKey.getTtl());
        this.decisionInstanceWriter.deleteDecisionInstancesByDefinitionKeyAndEvaluationDateOlderThan(decisionDefinitionKey, endDateFilter);
        LOG.info("Finished cleanup on decision instances for decisionDefinitionKey: {}, with ttl: {}", (Object)decisionDefinitionKey, (Object)cleanupConfigurationForKey.getTtl());
    }

    private Set<String> getAllOptimizeDecisionDefinitionKeys() {
        return this.decisionDefinitionReader.getAllDecisionDefinitions().stream().map(DefinitionOptimizeResponseDto::getKey).collect(Collectors.toSet());
    }

    private CleanupConfiguration getCleanupConfiguration() {
        return this.configurationService.getCleanupServiceConfiguration();
    }
}

