/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.alert;

import io.camunda.optimize.service.alert.AlertJobResult;
import io.camunda.optimize.service.alert.AlertReminderJobFactory;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.SchedulerException;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReminderHandlingListener
implements JobListener {
    private static final String LISTENER_NAME = "alert-reminder-handler";
    private static final Logger LOG = LoggerFactory.getLogger(ReminderHandlingListener.class);
    private final AlertReminderJobFactory alertReminderJobFactory;

    public ReminderHandlingListener(AlertReminderJobFactory reminderJobFactory) {
        this.alertReminderJobFactory = reminderJobFactory;
    }

    public String getName() {
        return LISTENER_NAME;
    }

    public void jobToBeExecuted(JobExecutionContext context) {
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        AlertJobResult result = (AlertJobResult)context.getResult();
        if (result != null && result.isStatusChanged()) {
            if (result.getAlert().isTriggered() && result.getAlert().getReminder() != null) {
                LOG.debug("Creating reminder job for [{}]", (Object)result.getAlert().getId());
                JobDetail jobDetails = this.alertReminderJobFactory.createJobDetails(result.getAlert());
                try {
                    if (context.getScheduler().checkExists(jobDetails.getKey())) {
                        LOG.debug("Skipping creating new job with key [{}] as it already exists", (Object)jobDetails.getKey());
                        return;
                    }
                    context.getScheduler().scheduleJob(jobDetails, this.alertReminderJobFactory.createTrigger(result.getAlert(), jobDetails));
                }
                catch (Exception e) {
                    LOG.error("can't schedule reminder for [{}]", (Object)result.getAlert().getId(), (Object)e);
                }
            } else {
                JobKey jobKey = this.alertReminderJobFactory.getJobKey(result.getAlert());
                TriggerKey triggerKey = this.alertReminderJobFactory.getTriggerKey(result.getAlert());
                try {
                    context.getScheduler().unscheduleJob(triggerKey);
                    context.getScheduler().deleteJob(jobKey);
                }
                catch (SchedulerException e) {
                    LOG.error("can't remove reminders for alert [{}]", (Object)result.getAlert().getId());
                }
            }
        }
    }
}

