/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.alert;

import io.camunda.optimize.service.alert.AlertRecipientValidator;
import io.camunda.optimize.service.exceptions.OptimizeAlertEmailValidationException;
import io.camunda.optimize.service.identity.CCSaaSIdentityService;
import io.camunda.optimize.service.util.configuration.condition.CCSaaSCondition;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={CCSaaSCondition.class})
@Component
public class CCSaaSAlertRecipientValidator
implements AlertRecipientValidator {
    private final CCSaaSIdentityService identityService;

    public CCSaaSAlertRecipientValidator(CCSaaSIdentityService identityService) {
        this.identityService = identityService;
    }

    @Override
    public void validateAlertRecipientEmailAddresses(List<String> emails) {
        Set lowerCasedUserEmails;
        Set<String> emailsForSearch = emails.stream().filter(StringUtils::isNotBlank).map(email -> email.toLowerCase(Locale.ENGLISH).trim()).collect(Collectors.toSet());
        Collection unknownEmails = CollectionUtils.subtract(emailsForSearch, lowerCasedUserEmails = this.identityService.getUsersByEmail(emailsForSearch).stream().map(user -> user.getEmail().toLowerCase(Locale.ENGLISH)).collect(Collectors.toSet()));
        if (!unknownEmails.isEmpty()) {
            throw new OptimizeAlertEmailValidationException(new HashSet<String>(unknownEmails));
        }
    }
}

