/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.alert;

import io.camunda.optimize.dto.optimize.alert.AlertNotificationDto;
import io.camunda.optimize.service.alert.AlertNotificationService;
import io.camunda.optimize.service.email.EmailService;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AlertEmailNotificationService
implements AlertNotificationService {
    private static final Logger LOG = LoggerFactory.getLogger(AlertEmailNotificationService.class);
    private final ConfigurationService configurationService;
    private final EmailService emailService;

    public AlertEmailNotificationService(ConfigurationService configurationService, EmailService emailService) {
        this.configurationService = configurationService;
        this.emailService = emailService;
    }

    @Override
    public void notify(AlertNotificationDto notification) {
        if (notification == null) {
            throw new IllegalArgumentException("Notification cannot be null");
        }
        List recipients = notification.getAlert().getEmails();
        LOG.info("Sending email of type {} to {} recipients for alert with ID {}", new Object[]{notification.getType(), recipients.size(), notification.getAlert().getId()});
        this.notify(notification.getAlertMessage(), recipients);
    }

    @Override
    public String getNotificationDescription() {
        return "alert email";
    }

    private void notify(String text, List<String> recipients) {
        String textWithTracking = text + "&utm_medium=email";
        recipients.forEach(recipient -> this.emailService.sendEmailWithErrorHandling((String)recipient, textWithTracking, "[" + this.configurationService.getNotificationEmailCompanyBranding() + "-Optimize] - Report status"));
    }
}

