/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.io.ByteStreams;
import io.camunda.optimize.dto.optimize.query.report.single.ViewProperty;
import io.camunda.optimize.service.exceptions.OptimizeConfigurationException;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.FilenameValidatorUtil;
import io.camunda.optimize.service.util.configuration.ConfigurationReloadable;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.agrona.Strings;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class LocalizationService
implements ConfigurationReloadable {
    public static final String LOCALIZATION_PATH = "localization/";
    public static final String REPORT_COUNT_KEY = "count";
    public static final String REPORT_DURATION_KEY = "duration";
    private static final String API_ERRORS_FIELD = "apiErrors";
    private static final String MANAGEMENT_DASHBOARD_FIELD = "managementDashboard";
    private static final String INSTANT_DASHBOARD_FIELD = "instantDashboard";
    private static final String JSON_FILE_EXTENSION = "json";
    private static final String REPORT_FIELD = "report";
    private static final String REPORT_GROUPING_FIELD = "groupBy";
    private static final String REPORT_VIEW_FIELD = "view";
    private static final String MISSING_ASSIGNEE_FIELD = "missingAssignee";
    private static final Logger LOG = LoggerFactory.getLogger(LocalizationService.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final ConfigurationService configurationService;
    private LoadingCache<String, Map<String, Object>> localeToLocalizationMapCache;

    public LocalizationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
        this.validateLocalizationSetup();
    }

    public void reloadConfiguration(ApplicationContext context) {
        this.validateLocalizationSetup();
    }

    public byte[] getLocalizationFileBytes(String localeCode) {
        return this.getLocalizedJsonFile(localeCode);
    }

    public String getDefaultLocaleMessageForApiErrorCode(String code) {
        try {
            return this.getMessageForCode(this.configurationService.getFallbackLocale(), API_ERRORS_FIELD, code);
        }
        catch (Exception e) {
            return String.format("Failed to localize error message for code [%s]", code);
        }
    }

    public String getDefaultLocaleMessageForMissingAssigneeLabel() {
        try {
            return this.getMessageForCode(this.configurationService.getFallbackLocale(), REPORT_FIELD, MISSING_ASSIGNEE_FIELD);
        }
        catch (Exception e) {
            return String.format("Failed to localize label for missing assignee field with localization code: %s", MISSING_ASSIGNEE_FIELD);
        }
    }

    public String getLocalizationForManagementDashboardCode(String localeCode, String dashboardCode) {
        return this.getMessageForCode(localeCode, MANAGEMENT_DASHBOARD_FIELD, dashboardCode);
    }

    public String getLocalizationForInstantPreviewDashboardCode(String localeCode, String dashboardCode) {
        return this.getMessageForCode(localeCode, INSTANT_DASHBOARD_FIELD, dashboardCode);
    }

    public String getLocalizationForManagementReportCode(String localeCode, String reportCode) {
        return this.getNestedMessageForCode(localeCode, MANAGEMENT_DASHBOARD_FIELD, REPORT_FIELD, reportCode);
    }

    public String getLocalizationForInstantPreviewReportCode(String localeCode, String reportCode) {
        return this.getNestedMessageForCode(localeCode, INSTANT_DASHBOARD_FIELD, REPORT_FIELD, reportCode);
    }

    public String getLocalizedXLabel(String validLocale, String xLabelKey) {
        if (Strings.isEmpty((String)xLabelKey)) {
            return xLabelKey;
        }
        Map<String, Map<String, String>> reportLocalistionMap = this.getNestedLocalizationMap(validLocale, REPORT_FIELD);
        Map<String, String> reportGroupByMap = reportLocalistionMap.get(REPORT_GROUPING_FIELD);
        return reportGroupByMap.get(xLabelKey);
    }

    public String getLocalizedYLabel(String validLocale, String yLabel, ViewProperty view) {
        if (Strings.isEmpty((String)yLabel)) {
            return yLabel;
        }
        Map<String, Map<String, String>> reportLocalistionMap = this.getNestedLocalizationMap(validLocale, REPORT_FIELD);
        Map<String, String> reportGroupByMap = reportLocalistionMap.get(REPORT_VIEW_FIELD);
        String localizedReportView = reportGroupByMap.get(yLabel);
        if (view.equals((Object)ViewProperty.FREQUENCY)) {
            return localizedReportView + " " + reportGroupByMap.get(REPORT_COUNT_KEY);
        }
        if (view.equals((Object)ViewProperty.DURATION)) {
            return localizedReportView + " " + reportGroupByMap.get(REPORT_DURATION_KEY);
        }
        return localizedReportView;
    }

    public String validateAndReturnValidLocale(String locale) {
        if (this.configurationService.getAvailableLocales().contains(locale)) {
            return locale;
        }
        String fallbackLocale = this.configurationService.getFallbackLocale();
        LOG.error("No valid localization files found for given locale [{}]. Defaulting to fallback locale [{}] instead.", (Object)locale, (Object)fallbackLocale);
        return fallbackLocale;
    }

    private void validateLocalizationFiles() {
        this.configurationService.getAvailableLocales().forEach(locale -> {
            String filePath = this.resolveFilePath(JSON_FILE_EXTENSION, (String)locale);
            this.validateFileExists(filePath);
            this.validateJsonFile(filePath);
        });
    }

    private void validateFileExists(String fileName) {
        URL localizationFile = this.getClass().getClassLoader().getResource(fileName);
        if (localizationFile == null) {
            throw new OptimizeConfigurationException(String.format("File for configured availableLocale is not available [%s].", fileName));
        }
    }

    private void validateFallbackLocale() {
        if (!this.configurationService.getAvailableLocales().contains(this.configurationService.getFallbackLocale())) {
            String message = String.format("The configured fallbackLocale [%s] is not present in availableLocales %s.", this.configurationService.getFallbackLocale(), this.configurationService.getAvailableLocales().toString());
            throw new OptimizeConfigurationException(message);
        }
    }

    private void validateJsonFile(String fileName) {
        URL localizationFile = this.getClass().getClassLoader().getResource(fileName);
        try {
            this.objectMapper.readTree(localizationFile);
        }
        catch (IOException e) {
            throw new OptimizeConfigurationException(String.format("File for configured availableLocale is not a valid JSON file [%s].", fileName), (Exception)e);
        }
    }

    private byte[] getLocalizedJsonFile(String localeCode) {
        String resolvedLocaleCode = this.configurationService.getAvailableLocales().contains(localeCode) ? localeCode : this.configurationService.getFallbackLocale();
        FilenameValidatorUtil.validateFilename(resolvedLocaleCode);
        return this.getFileBytes(this.resolveFilePath(null, JSON_FILE_EXTENSION, resolvedLocaleCode));
    }

    private String resolveFilePath(String fileExtension, String localeCode) {
        return this.resolveFilePath(null, fileExtension, localeCode);
    }

    private String resolveFilePath(String filePrefix, String fileExtension, String localeCode) {
        Object prefix = StringUtils.isNotBlank((CharSequence)filePrefix) ? filePrefix + "_" : "";
        return LOCALIZATION_PATH + (String)prefix + localeCode + "." + fileExtension;
    }

    private byte[] getFileBytes(String localeFileName) {
        Optional<Object> result = Optional.empty();
        try (InputStream localeFileAsStream = this.getClass().getClassLoader().getResourceAsStream(localeFileName);){
            result = Optional.ofNullable(localeFileAsStream).flatMap(inputStream -> {
                try {
                    return Optional.of(ByteStreams.toByteArray((InputStream)inputStream));
                }
                catch (IOException e) {
                    LOG.error("Failed reading localization file {} from classpath", (Object)localeFileName, (Object)e);
                    return Optional.empty();
                }
            });
        }
        catch (IOException e) {
            LOG.debug("Failed closing stream of locale file {}.", (Object)localeFileName, (Object)e);
        }
        return (byte[])result.orElseThrow(() -> new OptimizeRuntimeException("Could not load localization file: " + localeFileName));
    }

    private String getMessageForCode(String localeCode, String categoryCode, String messageCode) {
        Map categoryMessageCodeMap = (Map)((Map)this.localeToLocalizationMapCache.get((Object)localeCode)).get(categoryCode);
        return (String)categoryMessageCodeMap.get(messageCode);
    }

    private String getNestedMessageForCode(String localeCode, String categoryCode, String subcategoryCode, String messageCode) {
        Map<String, Map<String, String>> categoryMessageCodeMap = this.getNestedLocalizationMap(localeCode, categoryCode);
        return categoryMessageCodeMap.get(subcategoryCode).get(messageCode);
    }

    private Map<String, Map<String, String>> getNestedLocalizationMap(String localeCode, String categoryCode) {
        return (Map)((Map)this.localeToLocalizationMapCache.get((Object)localeCode)).get(categoryCode);
    }

    private void validateLocalizationSetup() {
        this.validateLocalizationFiles();
        this.validateFallbackLocale();
        this.localeToLocalizationMapCache = Caffeine.newBuilder().maximumSize(5L).expireAfterAccess(30L, TimeUnit.MINUTES).build(localeCode -> (Map)this.objectMapper.readValue(this.getLocalizedJsonFile((String)localeCode), (TypeReference)new TypeReference<Map<String, Object>>(this){}));
    }
}

