/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.security.oauth;

import java.util.Map;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;

public class ScopeValidator
implements OAuth2TokenValidator<Jwt> {
    private final String expectedScope;
    private final JwtAuthenticationConverter delegate = new JwtAuthenticationConverter();

    public ScopeValidator(String expectedScope) {
        this.expectedScope = expectedScope;
    }

    public OAuth2TokenValidatorResult validate(Jwt jwt) {
        JwtAuthenticationToken auth = (JwtAuthenticationToken)this.delegate.convert(jwt);
        Map payload = auth.getTokenAttributes();
        return this.isScopeValid(payload);
    }

    private OAuth2TokenValidatorResult isScopeValid(Map<String, Object> payload) {
        String scope = this.getScope(payload);
        if (scope != null && !scope.isBlank()) {
            if (scope.contains(this.expectedScope)) {
                return OAuth2TokenValidatorResult.success();
            }
            return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{new OAuth2Error("invalid_token", "The scope provided in the token does not match the expected scope", null)});
        }
        return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{new OAuth2Error("missing_token", "The required scope is missing", null)});
    }

    private String getScope(Map<String, Object> payload) {
        return (String)payload.get("scope");
    }
}

