/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.security.cloud;

import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.CCSaaSCondition;
import io.camunda.optimize.service.util.configuration.security.CloudAuthConfiguration;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;

@Configuration
@Conditional(value={CCSaaSCondition.class})
public class CCSaasAuth0WebSecurityConfig {
    public static final String OAUTH_AUTH_ENDPOINT = "/sso";
    public static final String OAUTH_REDIRECT_ENDPOINT = "/sso-callback";
    public static final String AUTH0_JWKS_ENDPOINT = "/.well-known/jwks.json";
    public static final String URL_TEMPLATE = "https://%s%s";
    public static final String AUTH_0_CLIENT_REGISTRATION_ID = "auth0";
    public static final String AUTH0_AUTH_ENDPOINT = "/authorize";
    public static final String AUTH0_TOKEN_ENDPOINT = "/oauth/token";
    public static final String AUTH0_USERINFO_ENDPOINT = "/userinfo";
    private final ConfigurationService configurationService;

    public CCSaasAuth0WebSecurityConfig(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    @Bean
    public OAuth2AuthorizedClientService authorizedClientService() {
        return new InMemoryOAuth2AuthorizedClientService(this.clientRegistrationRepository());
    }

    @Bean
    public ClientRegistrationRepository clientRegistrationRepository() {
        ClientRegistration.Builder builder = ClientRegistration.withRegistrationId((String)AUTH_0_CLIENT_REGISTRATION_ID).clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_POST).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).redirectUri("{baseUrl}/sso-callback?uuid=" + this.getAuth0Configuration().getClusterId()).authorizationUri(this.buildAuth0CustomDomainUrl("/authorize?audience=" + this.getAuth0Configuration().getUserAccessTokenAudience().orElse(""))).tokenUri(this.buildAuth0DomainUrl(AUTH0_TOKEN_ENDPOINT)).userInfoUri(this.buildAuth0DomainUrl(AUTH0_USERINFO_ENDPOINT)).scope(new String[]{"openid", "profile"}).userNameAttributeName(this.getAuth0Configuration().getUserIdAttributeName()).clientId(this.getAuth0Configuration().getClientId()).clientSecret(this.getAuth0Configuration().getClientSecret()).jwkSetUri(String.format(URL_TEMPLATE, this.getAuth0Configuration().getDomain(), AUTH0_JWKS_ENDPOINT));
        return new InMemoryClientRegistrationRepository(List.of(builder.build()));
    }

    private String buildAuth0DomainUrl(String path) {
        return String.format(URL_TEMPLATE, this.getAuth0Configuration().getDomain(), path);
    }

    private String buildAuth0CustomDomainUrl(String path) {
        return String.format(URL_TEMPLATE, this.getAuth0Configuration().getCustomDomain(), path);
    }

    private CloudAuthConfiguration getAuth0Configuration() {
        return this.configurationService.getAuthConfiguration().getCloudAuthConfiguration();
    }
}

