/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.security.cloud;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationResponseType;

public class AuthorizationRequestCookieValueMapper {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public AuthorizationRequestCookieValueMapper() {
        this.objectMapper.addMixIn(OAuth2AuthorizationRequest.class, OAuth2AuthorizationRequestMixin.class);
        this.objectMapper.addMixIn(OAuth2AuthorizationResponseType.class, OAuth2AuthorizationResponseTypeMixin.class);
        this.objectMapper.addMixIn(AuthorizationGrantType.class, AuthorizationGrantTypeMixin.class);
    }

    public String serialize(OAuth2AuthorizationRequest authorizationRequest) {
        try {
            return Base64.getUrlEncoder().encodeToString(this.objectMapper.writeValueAsString((Object)authorizationRequest).getBytes(StandardCharsets.UTF_8));
        }
        catch (JsonProcessingException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
    }

    public OAuth2AuthorizationRequest deserialize(String value) {
        try {
            return (OAuth2AuthorizationRequest)this.objectMapper.readValue(Base64.getUrlDecoder().decode(value), OAuth2AuthorizationRequest.class);
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
    }

    private static abstract class OAuth2AuthorizationRequestMixin {
        @JsonProperty(value="grantType")
        AuthorizationGrantType authorizationGrantType;

        private OAuth2AuthorizationRequestMixin() {
        }
    }

    private static abstract class OAuth2AuthorizationResponseTypeMixin {
        @JsonCreator
        public OAuth2AuthorizationResponseTypeMixin(@JsonProperty(value="value") String value) {
        }
    }

    private static abstract class AuthorizationGrantTypeMixin {
        @JsonCreator
        public AuthorizationGrantTypeMixin(@JsonProperty(value="value") String value) {
        }
    }
}

