/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.security.ccsm;

import com.auth0.jwt.exceptions.TokenExpiredException;
import io.camunda.identity.sdk.authentication.AccessToken;
import io.camunda.identity.sdk.authentication.Tokens;
import io.camunda.identity.sdk.exception.IdentityException;
import io.camunda.optimize.rest.exceptions.NotAuthorizedException;
import io.camunda.optimize.service.security.AuthCookieService;
import io.camunda.optimize.service.security.CCSMTokenService;
import io.camunda.optimize.service.util.configuration.condition.CCSMCondition;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Conditional;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;

@Conditional(value={CCSMCondition.class})
public class CCSMAuthenticationCookieFilter
extends AbstractPreAuthenticatedProcessingFilter {
    private final CCSMTokenService ccsmTokenService;

    public CCSMAuthenticationCookieFilter(CCSMTokenService ccsmTokenService, AuthenticationManager authenticationManager) {
        this.ccsmTokenService = ccsmTokenService;
        this.setAuthenticationManager(authenticationManager);
    }

    public CCSMAuthenticationCookieFilter(CCSMTokenService ccsmTokenService) {
        this.ccsmTokenService = ccsmTokenService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Cookie[] cookies = ((HttpServletRequest)request).getCookies();
        if (cookies != null) {
            Map<String, Cookie> cookiesByName = Arrays.stream(cookies).collect(Collectors.toMap(Cookie::getName, Function.identity()));
            try {
                Optional.ofNullable((Cookie)cookiesByName.get("X-Optimize-Authorization")).ifPresentOrElse(accessTokenCookie -> this.ccsmTokenService.verifyToken(accessTokenCookie.getValue()), () -> this.tryCookieRenewal(request, response, cookiesByName));
            }
            catch (TokenExpiredException expiredException) {
                this.tryCookieRenewal(request, response, cookiesByName);
            }
            catch (IdentityException verificationException) {
                try {
                    Optional.ofNullable((Cookie)cookiesByName.get("X-Optimize-Refresh-Token")).ifPresent(refreshTokenCookie -> this.ccsmTokenService.revokeToken(refreshTokenCookie.getValue()));
                }
                catch (IdentityException identityException) {
                }
                finally {
                    this.deleteCookies(response);
                }
            }
            catch (NotAuthorizedException notAuthorizedException) {
                this.deleteCookies(response);
            }
        }
        super.doFilter(request, response, chain);
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        return Optional.ofNullable(request.getCookies()).flatMap(cookies -> Arrays.stream(request.getCookies()).filter(cookie -> cookie.getName().equals("X-Optimize-Authorization")).findFirst().flatMap(accessToken -> this.validToken(accessToken.getValue())).map(this.ccsmTokenService::getSubjectFromToken)).orElseGet(() -> AuthCookieService.getAuthCookieToken(request).flatMap(this::validToken).map(this.ccsmTokenService::getSubjectFromToken).orElse(null));
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        return Optional.ofNullable(request.getCookies()).flatMap(cookies -> Arrays.stream(request.getCookies()).filter(cookie -> cookie.getName().equals("X-Optimize-Authorization")).findFirst().map(Cookie::getValue)).orElseGet(() -> AuthCookieService.getAuthCookieToken(request).orElse(null));
    }

    private Optional<String> validToken(String token) {
        try {
            this.ccsmTokenService.verifyToken(token);
        }
        catch (Exception e) {
            return Optional.empty();
        }
        return Optional.ofNullable(token);
    }

    private void tryCookieRenewal(ServletRequest request, ServletResponse response, Map<String, Cookie> cookiesByName) {
        Optional.ofNullable(cookiesByName.get("X-Optimize-Refresh-Token")).ifPresent(refreshTokenCookie -> {
            Tokens tokens = this.ccsmTokenService.renewToken(refreshTokenCookie.getValue());
            AccessToken accessToken = this.ccsmTokenService.verifyToken(tokens.getAccessToken());
            request.setAttribute("X-Optimize-Authorization", (Object)accessToken.getToken().getToken());
            this.ccsmTokenService.createOptimizeAuthCookies(tokens, accessToken, request.getScheme()).forEach(arg_0 -> ((HttpServletResponse)((HttpServletResponse)response)).addCookie(arg_0));
        });
    }

    private void deleteCookies(ServletResponse response) {
        this.ccsmTokenService.createOptimizeDeleteAuthCookies().forEach(arg_0 -> ((HttpServletResponse)((HttpServletResponse)response)).addCookie(arg_0));
    }
}

