/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.mapper;

import io.camunda.optimize.dto.optimize.query.dashboard.DashboardDefinitionRestDto;
import io.camunda.optimize.dto.optimize.query.dashboard.tile.DashboardTileType;
import io.camunda.optimize.dto.optimize.rest.AuthorizedDashboardDefinitionResponseDto;
import io.camunda.optimize.service.LocalizationService;
import io.camunda.optimize.service.dashboard.InstantPreviewDashboardService;
import io.camunda.optimize.service.identity.AbstractIdentityService;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DashboardRestMapper {
    public static final String TEXT_FIELD = "text";
    private static final String TYPE_TEXT_VALUE = "text";
    private static final Logger LOG = LoggerFactory.getLogger(DashboardRestMapper.class);
    private final AbstractIdentityService identityService;
    private final LocalizationService localizationService;

    public DashboardRestMapper(AbstractIdentityService identityService, LocalizationService localizationService) {
        this.identityService = identityService;
        this.localizationService = localizationService;
    }

    public void prepareRestResponse(AuthorizedDashboardDefinitionResponseDto dashboardDefinitionDto, String locale) {
        this.prepareRestResponse(dashboardDefinitionDto.getDefinitionDto(), locale);
    }

    public void prepareRestResponse(DashboardDefinitionRestDto dashboardDefinitionDto, String locale) {
        this.prepareRestResponse(dashboardDefinitionDto, locale, false);
    }

    public void prepareRestResponse(DashboardDefinitionRestDto dashboardDefinitionDto, String locale, boolean skipNameResolution) {
        if (!skipNameResolution) {
            this.resolveOwnerAndModifierNames(dashboardDefinitionDto);
        }
        this.localizeDashboard(dashboardDefinitionDto, locale);
    }

    private void resolveOwnerAndModifierNames(DashboardDefinitionRestDto dashboardDefinitionDto) {
        Optional.ofNullable(dashboardDefinitionDto.getOwner()).flatMap(this.identityService::getIdentityNameById).ifPresent(arg_0 -> ((DashboardDefinitionRestDto)dashboardDefinitionDto).setOwner(arg_0));
        Optional.ofNullable(dashboardDefinitionDto.getLastModifier()).flatMap(this.identityService::getIdentityNameById).ifPresent(arg_0 -> ((DashboardDefinitionRestDto)dashboardDefinitionDto).setLastModifier(arg_0));
    }

    private void localizeDashboard(DashboardDefinitionRestDto dashboardDefinition, String locale) {
        if (dashboardDefinition.isManagementDashboard() || dashboardDefinition.isInstantPreviewDashboard()) {
            String validLocale = this.localizationService.validateAndReturnValidLocale(locale);
            if (dashboardDefinition.isManagementDashboard()) {
                Optional.ofNullable(this.localizationService.getLocalizationForManagementDashboardCode(validLocale, dashboardDefinition.getName())).ifPresent(arg_0 -> ((DashboardDefinitionRestDto)dashboardDefinition).setName(arg_0));
                Optional.ofNullable(this.localizationService.getLocalizationForManagementDashboardCode(validLocale, dashboardDefinition.getDescription())).ifPresent(arg_0 -> ((DashboardDefinitionRestDto)dashboardDefinition).setDescription(arg_0));
            } else {
                Optional.ofNullable(this.localizationService.getLocalizationForInstantPreviewDashboardCode(validLocale, dashboardDefinition.getName())).ifPresent(arg_0 -> ((DashboardDefinitionRestDto)dashboardDefinition).setName(arg_0));
                Optional.ofNullable(this.localizationService.getLocalizationForInstantPreviewDashboardCode(validLocale, dashboardDefinition.getDescription())).ifPresent(arg_0 -> ((DashboardDefinitionRestDto)dashboardDefinition).setDescription(arg_0));
                this.localizeTextsFromTextTiles(dashboardDefinition, validLocale);
            }
        }
    }

    private void localizeTextsFromTextTiles(DashboardDefinitionRestDto dashboardData, String locale) {
        dashboardData.getTiles().forEach(tile -> {
            if (tile.getType() == DashboardTileType.TEXT) {
                Map textTileConfiguration = (Map)tile.getConfiguration();
                InstantPreviewDashboardService.findAndConvertTileContent(textTileConfiguration, "text", this::localizeTextFromTile, locale);
            }
        });
    }

    private void localizeTextFromTile(Map<String, Object> textTileConfiguration, String locale) {
        String textContent = (String)textTileConfiguration.get("text");
        Optional.ofNullable(this.localizationService.getLocalizationForInstantPreviewDashboardCode(locale, textContent)).ifPresent(localizedText -> textTileConfiguration.put("text", localizedText));
    }
}

