/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.cloud;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.query.ui_configuration.AppName;
import io.camunda.optimize.rest.cloud.AbstractCCSaaSClient;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.CCSaaSCondition;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={CCSaaSCondition.class})
public class CCSaasClusterClient
extends AbstractCCSaaSClient {
    private static final String GET_CLUSTERS_TEMPLATE = "%s/external/organizations/%s/clusters";
    private static final Set<AppName> REQUIRED_WEBAPPS_LINKS = Set.of(AppName.CONSOLE, AppName.OPERATE, AppName.OPTIMIZE, AppName.MODELER, AppName.TASKLIST);
    private static final Logger LOG = LoggerFactory.getLogger(CCSaasClusterClient.class);
    private Map<AppName, String> webappsLinks;

    public CCSaasClusterClient(ConfigurationService configurationService, ObjectMapper objectMapper) {
        super(objectMapper, configurationService);
        objectMapper.enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL);
    }

    public Map<AppName, String> getWebappLinks(String accessToken) {
        if (MapUtils.isEmpty(this.webappsLinks)) {
            this.webappsLinks = this.retrieveWebappsLinks(accessToken);
        }
        return this.webappsLinks;
    }

    private Map<AppName, String> retrieveWebappsLinks(String accessToken) {
        try {
            ClusterMetadata[] metadataForAllClusters;
            LOG.info("Fetching cluster metadata.");
            HttpGet request = new HttpGet(String.format(GET_CLUSTERS_TEMPLATE, this.configurationService.getUiConfiguration().getConsoleUrl(), this.getCloudAuthConfiguration().getOrganizationId()));
            try (CloseableHttpResponse response = this.performRequest((HttpRequestBase)request, accessToken);){
                if (response.getStatusLine().getStatusCode() != HttpStatus.OK.value()) {
                    throw new OptimizeRuntimeException(String.format("Unexpected response when fetching cluster metadata: %s", response.getStatusLine().getStatusCode()));
                }
                LOG.info("Processing response from Cluster metadata");
                metadataForAllClusters = (ClusterMetadata[])this.objectMapper.readValue(response.getEntity().getContent(), ClusterMetadata[].class);
            }
            if (metadataForAllClusters != null) {
                String currentClusterId = this.getCloudAuthConfiguration().getClusterId();
                return Arrays.stream(metadataForAllClusters).filter(cm -> cm.getUuid().equals(currentClusterId)).findFirst().map(cluster -> this.mapToWebappsLinks(cluster.getUrls())).orElseThrow(() -> new OptimizeRuntimeException("Fetched Cluster metadata successfully, but there was no data for the cluster " + currentClusterId));
            }
            throw new OptimizeRuntimeException("Could not fetch Cluster metadata");
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException("There was a problem fetching cluster metadata.", (Throwable)e);
        }
    }

    private Map<AppName, String> mapToWebappsLinks(Map<AppName, String> urls) {
        urls.put(AppName.CONSOLE, this.configurationService.getUiConfiguration().getConsoleUrl());
        urls.put(AppName.MODELER, this.configurationService.getUiConfiguration().getModelerUrl());
        return urls.entrySet().stream().filter(entry -> entry.getValue() != null && entry.getKey() != null && REQUIRED_WEBAPPS_LINKS.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class ClusterMetadata
    implements Serializable {
        private String uuid;
        private Map<AppName, String> urls = new EnumMap<AppName, String>(AppName.class);

        public String getUuid() {
            return this.uuid;
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public Map<AppName, String> getUrls() {
            return this.urls;
        }

        public void setUrls(Map<AppName, String> urls) {
            this.urls = urls;
        }

        protected boolean canEqual(Object other) {
            return other instanceof ClusterMetadata;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public boolean equals(Object o) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
        }

        public String toString() {
            return "CCSaasClusterClient.ClusterMetadata(uuid=" + this.getUuid() + ", urls=" + String.valueOf(this.getUrls()) + ")";
        }
    }
}

