/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.cloud;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.camunda.optimize.dto.optimize.cloud.CloudUserDto;
import io.camunda.optimize.rest.cloud.AccountsUserAccessTokenProvider;
import io.camunda.optimize.rest.cloud.CCSaaSUserClient;
import io.camunda.optimize.rest.exceptions.NotAuthorizedException;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.service.util.configuration.CloudUserCacheConfiguration;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.CCSaaSCondition;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={CCSaaSCondition.class})
public class CCSaaSUserCache {
    private static final String ERROR_MISSING_ACCESS_TOKEN = "Missing user access token for service access.";
    private static final Logger LOG = LoggerFactory.getLogger(CCSaaSUserCache.class);
    private final Cache<String, CloudUserDto> cloudUsersCache;
    private final CCSaaSUserClient userClient;
    private final AccountsUserAccessTokenProvider accessTokenProvider;
    private final ConfigurationService configurationService;
    private OffsetDateTime cacheLastPopulatedTimestamp;

    public CCSaaSUserCache(CCSaaSUserClient userClient, AccountsUserAccessTokenProvider accessTokenProvider, ConfigurationService configurationService) {
        this.userClient = userClient;
        this.accessTokenProvider = accessTokenProvider;
        this.configurationService = configurationService;
        CloudUserCacheConfiguration cloudUsersCacheConfiguration = configurationService.getCaches().getCloudUsers();
        this.cloudUsersCache = Caffeine.newBuilder().maximumSize((long)cloudUsersCacheConfiguration.getMaxSize()).build();
        this.cacheLastPopulatedTimestamp = OffsetDateTime.MIN;
    }

    public Optional<CloudUserDto> getUserById(String userId) {
        Optional<CloudUserDto> cloudUser = Optional.ofNullable((CloudUserDto)this.cloudUsersCache.getIfPresent((Object)userId));
        if (cloudUser.isPresent()) {
            return cloudUser;
        }
        Optional fetchedUser = this.accessTokenProvider.getCurrentUsersAccessToken().map(accessToken -> this.userClient.getCloudUserById(userId, (String)accessToken)).orElseThrow(() -> new NotAuthorizedException(ERROR_MISSING_ACCESS_TOKEN));
        fetchedUser.ifPresent(user -> this.cloudUsersCache.put((Object)user.getUserId(), user));
        return fetchedUser;
    }

    public Collection<CloudUserDto> getUsersById(Set<String> userIds) {
        this.repopulateCacheIfMinFetchIntervalExceeded();
        return this.cloudUsersCache.getAllPresent(userIds).values();
    }

    public Collection<CloudUserDto> getAllUsers() {
        this.repopulateCacheIfMinFetchIntervalExceeded();
        return this.cloudUsersCache.asMap().values();
    }

    private synchronized void repopulateCacheIfMinFetchIntervalExceeded() {
        OffsetDateTime currentTime = LocalDateUtil.getCurrentDateTime();
        long secondsSinceCacheRepopulated = this.cacheLastPopulatedTimestamp.until(currentTime, ChronoUnit.SECONDS);
        if (secondsSinceCacheRepopulated > this.configurationService.getCaches().getCloudUsers().getMinFetchIntervalSeconds()) {
            this.cloudUsersCache.invalidateAll();
            this.cloudUsersCache.putAll(this.fetchAllUsersWithinOrganization());
            this.cacheLastPopulatedTimestamp = currentTime;
        }
    }

    private Map<String, CloudUserDto> fetchAllUsersWithinOrganization() {
        return this.accessTokenProvider.getCurrentUsersAccessToken().map(this.userClient::fetchAllCloudUsers).orElseThrow(() -> new NotAuthorizedException(ERROR_MISSING_ACCESS_TOKEN)).stream().collect(Collectors.toMap(CloudUserDto::getUserId, Function.identity()));
    }
}

