/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.cloud;

import io.camunda.optimize.service.security.AuthCookieService;
import io.camunda.optimize.service.util.configuration.condition.CCSaaSCondition;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
@Conditional(value={CCSaaSCondition.class})
public class AccountsUserAccessTokenProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AccountsUserAccessTokenProvider.class);

    private Optional<String> retrieveServiceTokenFromFramework() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            if (authentication instanceof JwtAuthenticationToken) {
                return Optional.ofNullable(((Jwt)((JwtAuthenticationToken)authentication).getToken()).getTokenValue());
            }
            LOG.info("Could not retrieve Jwt Token. Provided token has type " + authentication.getClass().getTypeName());
            return Optional.empty();
        }
        return Optional.empty();
    }

    public Optional<String> getCurrentUsersAccessToken() {
        Optional<String> accessToken = Optional.ofNullable(RequestContextHolder.getRequestAttributes()).filter(ServletRequestAttributes.class::isInstance).map(ServletRequestAttributes.class::cast).map(ServletRequestAttributes::getRequest).flatMap(AuthCookieService::getServiceAccessToken);
        if (accessToken.isEmpty()) {
            accessToken = this.retrieveServiceTokenFromFramework();
        }
        return accessToken;
    }
}

