/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest;

import io.camunda.optimize.dto.optimize.SettingsDto;
import io.camunda.optimize.dto.optimize.query.EntityIdResponseDto;
import io.camunda.optimize.dto.optimize.query.IdResponseDto;
import io.camunda.optimize.dto.optimize.query.variable.DefinitionVariableLabelsDto;
import io.camunda.optimize.dto.optimize.rest.export.OptimizeEntityExportDto;
import io.camunda.optimize.dto.optimize.rest.export.report.ReportDefinitionExportDto;
import io.camunda.optimize.dto.optimize.rest.pagination.PaginatedDataExportDto;
import io.camunda.optimize.dto.optimize.rest.pagination.PaginationScrollableDto;
import io.camunda.optimize.dto.optimize.rest.pagination.PaginationScrollableRequestDto;
import io.camunda.optimize.rest.exceptions.BadRequestException;
import io.camunda.optimize.service.SettingsService;
import io.camunda.optimize.service.dashboard.DashboardService;
import io.camunda.optimize.service.entities.EntityExportService;
import io.camunda.optimize.service.entities.EntityImportService;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.export.JsonReportResultExportService;
import io.camunda.optimize.service.report.ReportService;
import io.camunda.optimize.service.variable.ProcessVariableLabelService;
import jakarta.validation.Valid;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/api/public"})
public class PublicApiRestService {
    public static final String PUBLIC_PATH = "/public";
    public static final String EXPORT_SUB_PATH = "/export";
    public static final String IMPORT_SUB_PATH = "/import";
    public static final String REPORT_SUB_PATH = "/report";
    public static final String DASHBOARD_SUB_PATH = "/dashboard";
    public static final String LABELS_SUB_PATH = "/variables/labels";
    public static final String DASHBOARD_EXPORT_DEFINITION_SUB_PATH = "/export/dashboard/definition/json";
    private static final String REPORT_EXPORT_PATH = "/export/report";
    public static final String REPORT_EXPORT_DEFINITION_SUB_PATH = "/export/report/definition/json";
    private static final String REPORT_BY_ID_PATH = "/report/{reportId}";
    private static final String REPORT_EXPORT_BY_ID_PATH = "/export/report/{reportId}";
    private static final String REPORT_EXPORT_DATA_SUB_PATH = "/export/report/{reportId}/result/json";
    private static final String DASHBOARD_BY_ID_PATH = "/dashboard/{dashboardId}";
    private static final Logger LOG = LoggerFactory.getLogger(PublicApiRestService.class);
    private final JsonReportResultExportService jsonReportResultExportService;
    private final EntityExportService entityExportService;
    private final EntityImportService entityImportService;
    private final ReportService reportService;
    private final DashboardService dashboardService;
    private final ProcessVariableLabelService processVariableLabelService;
    private final SettingsService settingsService;

    public PublicApiRestService(JsonReportResultExportService jsonReportResultExportService, EntityExportService entityExportService, EntityImportService entityImportService, ReportService reportService, DashboardService dashboardService, ProcessVariableLabelService processVariableLabelService, SettingsService settingsService) {
        this.jsonReportResultExportService = jsonReportResultExportService;
        this.entityExportService = entityExportService;
        this.entityImportService = entityImportService;
        this.reportService = reportService;
        this.dashboardService = dashboardService;
        this.processVariableLabelService = processVariableLabelService;
        this.settingsService = settingsService;
    }

    @GetMapping(value={"/report"})
    public List<IdResponseDto> getReportIds(@RequestParam(name="collectionId", required=false) String collectionId) {
        this.validateCollectionIdNotNull(collectionId);
        return this.reportService.getAllReportIdsInCollection(collectionId);
    }

    @GetMapping(value={"/dashboard"})
    public List<IdResponseDto> getDashboardIds(@RequestParam(name="collectionId", required=false) String collectionId) {
        this.validateCollectionIdNotNull(collectionId);
        return this.dashboardService.getAllDashboardIdsInCollection(collectionId);
    }

    @GetMapping(value={"/export/report/{reportId}/result/json"})
    public PaginatedDataExportDto exportReportData(@PathVariable(value="reportId") String reportId, @Valid PaginationScrollableRequestDto paginationRequestDto) {
        ZoneId timezone = ZoneId.of("UTC");
        try {
            return this.jsonReportResultExportService.getJsonForEvaluatedReportResult(reportId, timezone, PaginationScrollableDto.fromPaginationRequest((PaginationScrollableRequestDto)paginationRequestDto));
        }
        catch (Exception ex) {
            throw new OptimizeRuntimeException((Throwable)ex);
        }
    }

    @PostMapping(value={"/export/report/definition/json"})
    public List<ReportDefinitionExportDto> exportReportDefinition(@RequestBody Set<String> reportIds) {
        return this.entityExportService.getReportExportDtos(Optional.ofNullable(reportIds).orElse(Collections.emptySet()));
    }

    @PostMapping(value={"/export/dashboard/definition/json"})
    public List<OptimizeEntityExportDto> exportDashboardDefinition(@RequestBody Set<String> dashboardIds) {
        return this.entityExportService.getDashboardExportDtos(Optional.ofNullable(dashboardIds).orElse(Collections.emptySet()));
    }

    @PostMapping(value={"/import"})
    public List<EntityIdResponseDto> importEntities(@RequestParam(name="collectionId", required=false) String collectionId, String exportedDtoJson) {
        this.validateCollectionIdNotNull(collectionId);
        Set<OptimizeEntityExportDto> exportDtos = this.entityImportService.readExportDtoOrFailIfInvalid(exportedDtoJson);
        return this.entityImportService.importEntities(collectionId, exportDtos);
    }

    @DeleteMapping(value={"/report/{reportId}"})
    public void deleteReportDefinition(@PathVariable(value="reportId") String reportId) {
        this.reportService.deleteReport(reportId);
    }

    @DeleteMapping(value={"/dashboard/{dashboardId}"})
    public void deleteDashboardDefinition(@PathVariable(value="dashboardId") String dashboardId) {
        this.dashboardService.deleteDashboard(dashboardId);
    }

    @PostMapping(value={"/variables/labels"})
    public void modifyVariableLabels(@Valid DefinitionVariableLabelsDto definitionVariableLabelsDto) {
        this.processVariableLabelService.storeVariableLabels(definitionVariableLabelsDto);
    }

    private void validateCollectionIdNotNull(String collectionId) {
        if (collectionId == null) {
            throw new BadRequestException("Must specify a collection ID for this request.");
        }
    }

    @PostMapping(value={"/share/enable"})
    public void enableShare() {
        SettingsDto settings = SettingsDto.builder().sharingEnabled(Boolean.valueOf(true)).build();
        this.settingsService.setSettings(settings);
    }

    @PostMapping(value={"/share/disable"})
    public void disableShare() {
        SettingsDto settings = SettingsDto.builder().sharingEnabled(Boolean.valueOf(false)).build();
        this.settingsService.setSettings(settings);
    }
}

