/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest;

import io.camunda.optimize.dto.optimize.IdentityWithMetadataResponseDto;
import io.camunda.optimize.dto.optimize.UserDto;
import io.camunda.optimize.dto.optimize.query.IdentitySearchResultResponseDto;
import io.camunda.optimize.dto.optimize.rest.UserResponseDto;
import io.camunda.optimize.rest.exceptions.NotFoundException;
import io.camunda.optimize.service.identity.AbstractIdentityService;
import io.camunda.optimize.service.security.SessionService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/identity"})
public class IdentityRestService {
    public static final String IDENTITY_RESOURCE_PATH = "/identity";
    public static final String IDENTITY_SEARCH_SUB_PATH = "/search";
    public static final String CURRENT_USER_IDENTITY_SUB_PATH = "/current/user";
    private static final Logger LOG = LoggerFactory.getLogger(IdentityRestService.class);
    private final AbstractIdentityService identityService;
    private final SessionService sessionService;

    public IdentityRestService(AbstractIdentityService identityService, SessionService sessionService) {
        this.identityService = identityService;
        this.sessionService = sessionService;
    }

    @GetMapping(path={"/search"})
    public IdentitySearchResultResponseDto searchIdentity(@RequestParam(value="terms", required=false) String searchTerms, @RequestParam(value="limit", defaultValue="25") int limit, @RequestParam(value="excludeUserGroups", required=false) boolean excludeUserGroups, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        return this.identityService.searchForIdentitiesAsUser(userId, Optional.ofNullable(searchTerms).orElse(""), limit, excludeUserGroups);
    }

    @GetMapping(path={"/{id}"})
    public IdentityWithMetadataResponseDto getIdentityById(@PathVariable(value="id") String identityId, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        return this.identityService.getIdentityWithMetadataForIdAsUser(userId, identityId).orElseThrow(() -> new NotFoundException("Could find neither a user nor a group with the id [" + identityId + "]."));
    }

    @GetMapping(path={"/current/user"})
    public UserResponseDto getCurrentUser(HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        UserDto currentUserDto = this.identityService.getCurrentUserById(userId, request).orElseGet(() -> new UserDto(userId));
        return new UserResponseDto(currentUserDto, this.identityService.getEnabledAuthorizations());
    }
}

