/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest;

import io.camunda.optimize.dto.optimize.DecisionDefinitionOptimizeDto;
import io.camunda.optimize.dto.optimize.DefinitionOptimizeResponseDto;
import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.ProcessDefinitionOptimizeDto;
import io.camunda.optimize.dto.optimize.query.definition.DefinitionKeyResponseDto;
import io.camunda.optimize.dto.optimize.query.definition.DefinitionResponseDto;
import io.camunda.optimize.dto.optimize.query.definition.TenantWithDefinitionsResponseDto;
import io.camunda.optimize.dto.optimize.rest.DefinitionVersionResponseDto;
import io.camunda.optimize.dto.optimize.rest.TenantResponseDto;
import io.camunda.optimize.dto.optimize.rest.definition.DefinitionWithTenantsResponseDto;
import io.camunda.optimize.dto.optimize.rest.definition.MultiDefinitionTenantsRequestDto;
import io.camunda.optimize.rest.exceptions.NotFoundException;
import io.camunda.optimize.rest.providers.CacheRequest;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.collection.CollectionScopeService;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.security.SessionService;
import io.camunda.optimize.service.util.DefinitionVersionHandlingUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/api/definition"})
public class DefinitionRestService {
    public static final String DEFINITION_PATH = "/definition";
    private static final Logger LOG = LoggerFactory.getLogger(DefinitionRestService.class);
    private final DefinitionService definitionService;
    private final CollectionScopeService collectionScopeService;
    private final SessionService sessionService;

    public DefinitionRestService(DefinitionService definitionService, CollectionScopeService collectionScopeService, SessionService sessionService) {
        this.definitionService = definitionService;
        this.collectionScopeService = collectionScopeService;
        this.sessionService = sessionService;
    }

    @GetMapping
    public List<DefinitionResponseDto> getDefinitions(HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        return this.definitionService.getFullyImportedDefinitions(userId);
    }

    @GetMapping(value={"/{type}"})
    public List<DefinitionOptimizeResponseDto> getDefinitions(@PathVariable(value="type") DefinitionType type, @RequestParam(name="includeXml", required=false) boolean includeXml, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        return this.definitionService.getFullyImportedDefinitions(type, userId, includeXml);
    }

    @PostMapping(value={"/{type}/_resolveTenantsForVersions"})
    public List<DefinitionWithTenantsResponseDto> getDefinitionTenantsForMultipleKeys(@PathVariable(value="type") DefinitionType type, @Valid @RequestBody MultiDefinitionTenantsRequestDto request, HttpServletRequest servletRequest) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(servletRequest);
        if (CollectionUtils.isEmpty(request.getDefinitions())) {
            return Collections.emptyList();
        }
        return request.getDefinitions().stream().map(definition -> {
            List<TenantResponseDto> tenantsForDefinitionVersions = this.getTenantsForDefinitionVersions(definition.getKey(), type, definition.getVersions(), request.getFilterByCollectionScope(), userId);
            return new DefinitionWithTenantsResponseDto(definition.getKey(), definition.getVersions(), tenantsForDefinitionVersions);
        }).collect(Collectors.toList());
    }

    @GetMapping(value={"/{type}/{key}"})
    public DefinitionResponseDto getDefinition(@PathVariable(value="type") DefinitionType type, @PathVariable(value="key") String key, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        return this.definitionService.getDefinitionWithAvailableTenants(type, key, userId).orElseThrow(() -> {
            String reason = String.format("Was not able to find definition for type [%s] and key [%s].", type, key);
            LOG.error(reason);
            return new NotFoundException(reason);
        });
    }

    @GetMapping(value={"/{type}/{key}/versions"})
    public List<DefinitionVersionResponseDto> getDefinitionVersions(@PathVariable(value="type") DefinitionType type, @PathVariable(value="key") String key, @RequestParam(value="filterByCollectionScope", required=false) String collectionId, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        Optional<String> optionalCollectionId = Optional.ofNullable(collectionId);
        List definitionVersions = optionalCollectionId.map(id -> this.collectionScopeService.getCollectionDefinitionVersionsByKeyAndType(type, key, userId, (String)id)).orElseGet(() -> this.definitionService.getDefinitionVersions(type, key, userId));
        if (definitionVersions.isEmpty()) {
            String reason = String.format("Was not able to find definition version for type [%s] and key [%s] in scope of collection [%s].", type, key, collectionId);
            LOG.error(reason);
            throw new NotFoundException(reason);
        }
        try {
            definitionVersions.sort(Comparator.comparing(definitionVersionDto -> Integer.valueOf(definitionVersionDto.getVersion())).reversed());
        }
        catch (NumberFormatException exception) {
            throw new OptimizeRuntimeException("Error while parsing versions for sorting definitions: " + String.valueOf(definitionVersions.stream().map(DefinitionVersionResponseDto::getVersion).toList()));
        }
        return definitionVersions;
    }

    @GetMapping(value={"/{type}/keys"})
    public List<DefinitionKeyResponseDto> getDefinitionKeys(@PathVariable(name="type") DefinitionType type, @RequestParam(name="filterByCollectionScope", required=false) String collectionId, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        List<DefinitionResponseDto> definitions = this.getDefinitions(type, collectionId, userId);
        return definitions.stream().map(definition -> new DefinitionKeyResponseDto(definition.getKey(), definition.getName())).collect(Collectors.toList());
    }

    @GetMapping(value={"/_groupByTenant"})
    public List<TenantWithDefinitionsResponseDto> getDefinitionsGroupedByTenant(HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        return this.definitionService.getDefinitionsGroupedByTenant(userId);
    }

    @GetMapping(path={"/{type}/xml"}, produces={"application/xml"})
    @CacheRequest
    public ResponseEntity<String> getDefinitionXml(@PathVariable(value="type") DefinitionType type, @RequestParam(name="key", required=false) String key, @RequestParam(name="version", required=false) String version, @RequestParam(name="tenantId", required=false) String tenantId, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        Optional definitionDto = this.definitionService.getDefinitionWithXml(type, userId, key, version, tenantId);
        if (definitionDto.isEmpty()) {
            this.logAndThrowNotFoundException(type, key, version);
        }
        ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.ok().contentType(MediaType.APPLICATION_XML);
        if (DefinitionVersionHandlingUtil.isDefinitionVersionSetToAllOrLatest(version)) {
            this.addNoStoreCacheHeader(bodyBuilder);
        }
        String xml = switch (type) {
            default -> throw new MatchException(null, null);
            case DefinitionType.PROCESS -> ((ProcessDefinitionOptimizeDto)definitionDto.get()).getBpmn20Xml();
            case DefinitionType.DECISION -> ((DecisionDefinitionOptimizeDto)definitionDto.get()).getDmn10Xml();
        };
        return bodyBuilder.body((Object)xml);
    }

    private List<TenantResponseDto> getTenantsForDefinitionVersions(String definitionKey, DefinitionType type, List<String> versions, String scopeCollectionId, String userId) {
        List tenants = Optional.ofNullable(scopeCollectionId).map(collectionId -> this.collectionScopeService.getCollectionDefinitionTenantsByKeyAndType(type, definitionKey, userId, versions, (String)collectionId)).orElseGet(() -> this.definitionService.getDefinitionTenants(type, definitionKey, userId, versions));
        if (tenants.isEmpty()) {
            String reason = String.format("Was not able to find definition tenants for type [%s], key [%s], versions [%s] in scope of collection [%s].", type, definitionKey, versions, scopeCollectionId);
            LOG.error(reason);
            throw new NotFoundException(reason);
        }
        return tenants.stream().map(tenantDto -> new TenantResponseDto(tenantDto.getId(), tenantDto.getName())).collect(Collectors.toList());
    }

    private List<DefinitionResponseDto> getDefinitions(DefinitionType type, String collectionId, String userId) {
        if (collectionId != null) {
            return this.collectionScopeService.getCollectionDefinitions(type, userId, collectionId);
        }
        return this.definitionService.getFullyImportedDefinitions(type, userId);
    }

    private void addNoStoreCacheHeader(ResponseEntity.BodyBuilder bodyBuilder) {
        bodyBuilder.header("Cache-Control", new String[]{"no-store"});
    }

    private void logAndThrowNotFoundException(DefinitionType type, String key, String version) {
        String notFoundErrorMessage = String.format("Could not find xml for [%s] definition with key [%s] and version [%s]. It is possible that it hasn't been imported yet.", type, key, version);
        LOG.error(notFoundErrorMessage);
        throw new NotFoundException(notFoundErrorMessage);
    }
}

