/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest;

import io.camunda.optimize.dto.optimize.GroupDto;
import io.camunda.optimize.dto.optimize.query.IdentitySearchResultResponseDto;
import io.camunda.optimize.dto.optimize.query.definition.AssigneeCandidateGroupDefinitionSearchRequestDto;
import io.camunda.optimize.dto.optimize.query.definition.AssigneeCandidateGroupReportSearchRequestDto;
import io.camunda.optimize.service.AssigneeCandidateGroupService;
import io.camunda.optimize.service.security.SessionService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/api/candidateGroup"})
public class CandidateGroupRestService {
    public static final String CANDIDATE_GROUP_RESOURCE_PATH = "/candidateGroup";
    public static final String CANDIDATE_GROUP_DEFINITION_SEARCH_SUB_PATH = "/search";
    public static final String CANDIDATE_GROUP_REPORTS_SEARCH_SUB_PATH = "/search/reports";
    private static final Logger LOG = LoggerFactory.getLogger(CandidateGroupRestService.class);
    private final SessionService sessionService;
    private final AssigneeCandidateGroupService assigneeCandidateGroupService;

    public CandidateGroupRestService(SessionService sessionService, AssigneeCandidateGroupService assigneeCandidateGroupService) {
        this.sessionService = sessionService;
        this.assigneeCandidateGroupService = assigneeCandidateGroupService;
    }

    @GetMapping
    public List<GroupDto> getCandidateGroupsByIds(@RequestParam(name="idIn", required=false) String commaSeparatedIdn) {
        if (StringUtils.isEmpty((CharSequence)commaSeparatedIdn)) {
            return Collections.emptyList();
        }
        return this.assigneeCandidateGroupService.getCandidateGroupsByIds(Arrays.asList(commaSeparatedIdn.split(",")));
    }

    @PostMapping(value={"/search"})
    public IdentitySearchResultResponseDto searchCandidateGroups(@Valid @RequestBody AssigneeCandidateGroupDefinitionSearchRequestDto requestDto, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        return this.assigneeCandidateGroupService.searchForCandidateGroupsAsUser(userId, requestDto);
    }

    @PostMapping(value={"/search/reports"})
    public IdentitySearchResultResponseDto searchCandidateGroups(@Valid @RequestBody AssigneeCandidateGroupReportSearchRequestDto requestDto, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        return this.assigneeCandidateGroupService.searchForCandidateGroupsAsUser(userId, requestDto);
    }
}

