/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest;

import io.camunda.optimize.dto.optimize.UserDto;
import io.camunda.optimize.dto.optimize.query.IdentitySearchResultResponseDto;
import io.camunda.optimize.dto.optimize.query.definition.AssigneeCandidateGroupDefinitionSearchRequestDto;
import io.camunda.optimize.dto.optimize.query.definition.AssigneeCandidateGroupReportSearchRequestDto;
import io.camunda.optimize.service.AssigneeCandidateGroupService;
import io.camunda.optimize.service.security.SessionService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/api/assignee"})
public class AssigneeRestService {
    public static final String ASSIGNEE_RESOURCE_PATH = "/assignee";
    public static final String ASSIGNEE_DEFINITION_SEARCH_SUB_PATH = "/search";
    public static final String ASSIGNEE_REPORTS_SEARCH_SUB_PATH = "/search/reports";
    private static final Logger LOG = LoggerFactory.getLogger(AssigneeRestService.class);
    private final SessionService sessionService;
    private final AssigneeCandidateGroupService assigneeCandidateGroupService;

    public AssigneeRestService(SessionService sessionService, AssigneeCandidateGroupService assigneeCandidateGroupService) {
        this.sessionService = sessionService;
        this.assigneeCandidateGroupService = assigneeCandidateGroupService;
    }

    @GetMapping
    public List<UserDto> getAssigneesByIds(@RequestParam(name="idIn", required=false) String commaSeparatedIdn) {
        if (StringUtils.isEmpty((CharSequence)commaSeparatedIdn)) {
            return Collections.emptyList();
        }
        return this.assigneeCandidateGroupService.getAssigneesByIds(Arrays.asList(commaSeparatedIdn.split(",")));
    }

    @PostMapping(value={"/search"})
    public IdentitySearchResultResponseDto searchAssignees(@Valid @RequestBody AssigneeCandidateGroupDefinitionSearchRequestDto requestDto, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        return this.assigneeCandidateGroupService.searchForAssigneesAsUser(userId, requestDto);
    }

    @PostMapping(value={"/search/reports"})
    public IdentitySearchResultResponseDto searchAssignees(@Valid @RequestBody AssigneeCandidateGroupReportSearchRequestDto requestDto, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        return this.assigneeCandidateGroupService.searchForAssigneesAsUser(userId, requestDto);
    }
}

