/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.dto.zeebe.usertask;

import io.camunda.optimize.service.util.DateFormatterUtil;
import io.camunda.zeebe.protocol.record.value.UserTaskRecordValue;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import net.minidev.json.annotate.JsonIgnore;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeebeUserTaskDataDto
implements UserTaskRecordValue {
    private static final Logger LOG = LoggerFactory.getLogger(ZeebeUserTaskDataDto.class);
    private long userTaskKey;
    private String assignee;
    private List<String> candidateGroupsList;
    private List<String> candidateUsersList;
    private String dueDate;
    private String elementId;
    private long elementInstanceKey;
    private String bpmnProcessId;
    private int processDefinitionVersion;
    private long processDefinitionKey;
    private long processInstanceKey;
    private String tenantId;
    private List<String> changedAttributes;
    private Map<String, Object> variables;
    private String followUpDate;
    private long formKey;
    private String action;
    private String externalFormReference;
    private Map<String, String> customHeaders;
    private long creationTimestamp;

    @JsonIgnore
    public OffsetDateTime getDateForDueDate() {
        return DateFormatterUtil.getOffsetDateTimeFromIsoZoneDateTimeString(this.dueDate).orElseGet(() -> {
            LOG.info("Unable to parse due date of userTask record: {}. UserTask will be imported without dueDate data.", (Object)this.dueDate);
            return null;
        });
    }

    public int getPriority() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public long getUserTaskKey() {
        return this.userTaskKey;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public List<String> getCandidateGroupsList() {
        return this.candidateGroupsList;
    }

    public List<String> getCandidateUsersList() {
        return this.candidateUsersList;
    }

    public String getDueDate() {
        return this.dueDate;
    }

    public String getElementId() {
        return this.elementId;
    }

    public long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    public int getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    public long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public List<String> getChangedAttributes() {
        return this.changedAttributes;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public String getFollowUpDate() {
        return this.followUpDate;
    }

    public long getFormKey() {
        return this.formKey;
    }

    public String getAction() {
        return this.action;
    }

    public String getExternalFormReference() {
        return this.externalFormReference;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public void setUserTaskKey(long userTaskKey) {
        this.userTaskKey = userTaskKey;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public void setCandidateGroupsList(List<String> candidateGroupsList) {
        this.candidateGroupsList = candidateGroupsList;
    }

    public void setCandidateUsersList(List<String> candidateUsersList) {
        this.candidateUsersList = candidateUsersList;
    }

    public void setDueDate(String dueDate) {
        this.dueDate = dueDate;
    }

    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    public void setElementInstanceKey(long elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
    }

    public void setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessId = bpmnProcessId;
    }

    public void setProcessDefinitionVersion(int processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
    }

    public void setProcessDefinitionKey(long processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public void setProcessInstanceKey(long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setChangedAttributes(List<String> changedAttributes) {
        this.changedAttributes = changedAttributes;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public void setFollowUpDate(String followUpDate) {
        this.followUpDate = followUpDate;
    }

    public void setFormKey(long formKey) {
        this.formKey = formKey;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setExternalFormReference(String externalFormReference) {
        this.externalFormReference = externalFormReference;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders = customHeaders;
    }

    public void setCreationTimestamp(long creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ZeebeUserTaskDataDto;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return "ZeebeUserTaskDataDto(userTaskKey=" + this.getUserTaskKey() + ", assignee=" + this.getAssignee() + ", candidateGroupsList=" + String.valueOf(this.getCandidateGroupsList()) + ", candidateUsersList=" + String.valueOf(this.getCandidateUsersList()) + ", dueDate=" + this.getDueDate() + ", elementId=" + this.getElementId() + ", elementInstanceKey=" + this.getElementInstanceKey() + ", bpmnProcessId=" + this.getBpmnProcessId() + ", processDefinitionVersion=" + this.getProcessDefinitionVersion() + ", processDefinitionKey=" + this.getProcessDefinitionKey() + ", processInstanceKey=" + this.getProcessInstanceKey() + ", tenantId=" + this.getTenantId() + ", changedAttributes=" + String.valueOf(this.getChangedAttributes()) + ", variables=" + String.valueOf(this.getVariables()) + ", followUpDate=" + this.getFollowUpDate() + ", formKey=" + this.getFormKey() + ", action=" + this.getAction() + ", externalFormReference=" + this.getExternalFormReference() + ", customHeaders=" + String.valueOf(this.getCustomHeaders()) + ", creationTimestamp=" + this.getCreationTimestamp() + ")";
    }

    public static final class Fields {
        public static final String userTaskKey = "userTaskKey";
        public static final String assignee = "assignee";
        public static final String candidateGroupsList = "candidateGroupsList";
        public static final String candidateUsersList = "candidateUsersList";
        public static final String dueDate = "dueDate";
        public static final String elementId = "elementId";
        public static final String elementInstanceKey = "elementInstanceKey";
        public static final String bpmnProcessId = "bpmnProcessId";
        public static final String processDefinitionVersion = "processDefinitionVersion";
        public static final String processDefinitionKey = "processDefinitionKey";
        public static final String processInstanceKey = "processInstanceKey";
        public static final String tenantId = "tenantId";
        public static final String changedAttributes = "changedAttributes";
        public static final String variables = "variables";
        public static final String followUpDate = "followUpDate";
        public static final String formKey = "formKey";
        public static final String action = "action";
        public static final String externalFormReference = "externalFormReference";
        public static final String customHeaders = "customHeaders";
        public static final String creationTimestamp = "creationTimestamp";
    }
}

