/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize;

import io.camunda.optimize.service.exceptions.OptimizeConfigurationException;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.tomcat.OptimizeResourceConstants;
import io.camunda.optimize.tomcat.ResponseSecurityHeaderFilter;
import io.camunda.optimize.tomcat.ResponseTimezoneFilter;
import io.camunda.optimize.tomcat.URLRedirectFilter;
import jakarta.servlet.Filter;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class OptimizeTomcatConfig {
    public static final String EXTERNAL_SUB_PATH = "/external";
    private static final Logger LOG = LoggerFactory.getLogger(OptimizeTomcatConfig.class);
    private static final String[] COMPRESSED_MIME_TYPES = new String[]{"application/json", "text/html", "application/x-font-ttf", "image/svg+xml"};
    private static final String LOGIN_ENDPOINT = "/login";
    private static final String METRICS_ENDPOINT = "/metrics";
    private static final String URL_BASE = "/#";
    public static final String ALLOWED_URL_EXTENSION = String.join((CharSequence)"|", "/#", "/login", "/metrics", "/sso", "/sso-callback", "/.well-known/jwks.json", "/authorize", "/oauth/token", "/userinfo", "/readyz", "/localization", "/external", "/api", "/static", OptimizeResourceConstants.ACTUATOR_ENDPOINT, "/notifications/org", "/ui-configuration", "/favicon.ico", "/index.html");
    private static final String HTTP11_NIO_PROTOCOL = "org.apache.coyote.http11.Http11Nio2Protocol";
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private Environment environment;

    @Bean
    WebServerFactoryCustomizer<TomcatServletWebServerFactory> tomcatFactoryCustomizer() {
        LOG.debug("Setting up server connectors...");
        return new WebServerFactoryCustomizer<TomcatServletWebServerFactory>(){

            public void customize(TomcatServletWebServerFactory factory) {
                Optional<String> contextPath = OptimizeTomcatConfig.this.getContextPath();
                if (contextPath.isPresent()) {
                    factory.setContextPath(contextPath.get());
                }
                factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{connector -> {
                    if ("true".equals(OptimizeTomcatConfig.this.environment.getProperty("useLegacyPort"))) {
                        connector.setPort(8090);
                    }
                    connector.setProperty("maxHttpRequestHeaderSize", String.valueOf(OptimizeTomcatConfig.this.configurationService.getMaxRequestHeaderSizeInBytes()));
                    connector.setProperty("maxHttpResponseHeaderSize", String.valueOf(OptimizeTomcatConfig.this.configurationService.getMaxResponseHeaderSizeInBytes()));
                }});
            }
        };
    }

    @Bean
    FilterRegistrationBean<URLRedirectFilter> urlRedirector() {
        LOG.debug("Registering filter 'urlRedirector'...");
        String contextPath = this.getContextPath().orElse("");
        String regex = "^(?!(" + contextPath + ALLOWED_URL_EXTENSION + ")).+";
        URLRedirectFilter filter = new URLRedirectFilter(regex, contextPath + URL_BASE);
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setFilter((Filter)filter);
        return registration;
    }

    @Bean
    FilterRegistrationBean<ResponseSecurityHeaderFilter> responseHeadersInjector() {
        LOG.debug("Registering filter 'responseHeadersInjector'...");
        ResponseSecurityHeaderFilter responseSecurityHeaderFilter = new ResponseSecurityHeaderFilter(this.configurationService);
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.addUrlPatterns(new String[]{"/*"});
        registrationBean.setFilter((Filter)responseSecurityHeaderFilter);
        return registrationBean;
    }

    @Bean
    FilterRegistrationBean<ResponseTimezoneFilter> responseTimezoneFilter() {
        LOG.debug("Registering filter 'responseTimezoneFilter'...");
        ResponseTimezoneFilter filter = new ResponseTimezoneFilter();
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.addUrlPatterns(new String[]{"/*"});
        registrationBean.setFilter((Filter)filter);
        return registrationBean;
    }

    public int getPort(String portType) {
        String portProperty = this.environment.getProperty(portType);
        if (portProperty != null) {
            try {
                return Integer.parseInt(portProperty);
            }
            catch (NumberFormatException exception) {
                throw new OptimizeConfigurationException("Error while determining container port");
            }
        }
        if (portType.equals("httpsPort")) {
            return this.configurationService.getContainerHttpsPort();
        }
        Optional httpPort = this.configurationService.getContainerHttpPort();
        if (httpPort.isEmpty()) {
            throw new OptimizeConfigurationException("HTTP port not configured");
        }
        return (Integer)httpPort.get();
    }

    public Optional<String> getContextPath() {
        Optional<String> contextPath = Optional.ofNullable(this.environment.getProperty("contextPath"));
        if (contextPath.isEmpty()) {
            return this.configurationService.getContextPath();
        }
        return contextPath;
    }
}

