/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.test.util;

import java.time.DayOfWeek;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;

public final class DateModificationHelper {
    private DateModificationHelper() {
    }

    public static ZonedDateTime truncateToStartOfUnit(OffsetDateTime date, ChronoUnit unit) {
        return DateModificationHelper.truncateToStartOfUnit(date, unit, ZoneId.systemDefault());
    }

    public static ZonedDateTime truncateToStartOfUnit(OffsetDateTime date, ChronoUnit unit, ZoneId timezone) {
        ZonedDateTime truncatedDate = unit.equals(ChronoUnit.MINUTES) ? date.atZoneSameInstant(timezone).truncatedTo(unit) : (unit.equals(ChronoUnit.HOURS) ? date.atZoneSameInstant(timezone).truncatedTo(unit) : (unit.equals(ChronoUnit.DAYS) ? date.atZoneSameInstant(timezone).truncatedTo(unit) : (unit.equals(ChronoUnit.WEEKS) ? date.atZoneSameInstant(timezone).with(DayOfWeek.MONDAY).truncatedTo(ChronoUnit.DAYS) : (unit.equals(ChronoUnit.MONTHS) ? date.atZoneSameInstant(timezone).withDayOfMonth(1).truncatedTo(ChronoUnit.DAYS) : date.atZoneSameInstant(timezone).withDayOfYear(1).truncatedTo(ChronoUnit.DAYS)))));
        return truncatedDate;
    }
}

