/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.test.util;

import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.test.util.DateModificationHelper;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.TimeZone;

public class DateCreationFreezer {
    public static InnerDateFreezerBuilder dateFreezer() {
        return new DateCreationFreezer().createNewDateFreezerBuilder().setDateToFreezeToNow();
    }

    public static InnerDateFreezerBuilder dateFreezer(OffsetDateTime dateToFreeze) {
        return new DateCreationFreezer().createNewDateFreezerBuilder().dateToFreeze(dateToFreeze);
    }

    private InnerDateFreezerBuilder createNewDateFreezerBuilder() {
        return new InnerDateFreezerBuilder();
    }

    public static class InnerDateFreezerBuilder {
        private OffsetDateTime dateToFreeze;
        private String timezone = ZoneId.systemDefault().getId();
        private ChronoUnit unitToTruncateTo;

        public InnerDateFreezerBuilder setDateToFreezeToNow() {
            this.dateToFreeze = LocalDateUtil.getCurrentDateTime();
            return this;
        }

        public InnerDateFreezerBuilder dateToFreeze(OffsetDateTime dateToFreeze) {
            this.dateToFreeze = dateToFreeze;
            return this;
        }

        public InnerDateFreezerBuilder timezone(String timezone) {
            if (this.dateToFreeze != null) {
                this.dateToFreeze.atZoneSameInstant(ZoneId.of(timezone));
            }
            this.timezone = timezone;
            return this;
        }

        public InnerDateFreezerBuilder truncateToUnit(ChronoUnit unitToTruncateTo) {
            this.unitToTruncateTo = unitToTruncateTo;
            return this;
        }

        public OffsetDateTime freezeDateAndReturn() {
            if (this.dateToFreeze == null) {
                this.dateToFreeze = OffsetDateTime.now(TimeZone.getTimeZone(this.timezone).toZoneId());
            }
            if (this.unitToTruncateTo != null) {
                this.dateToFreeze = DateModificationHelper.truncateToStartOfUnit(this.dateToFreeze, this.unitToTruncateTo).toOffsetDateTime();
            }
            LocalDateUtil.setCurrentTime((OffsetDateTime)this.dateToFreeze);
            return LocalDateUtil.getCurrentDateTime();
        }
    }
}

