/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.test.it.extension.db;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.common.collect.ImmutableMap;
import io.camunda.optimize.ApplicationContextProvider;
import io.camunda.optimize.dto.optimize.OptimizeDto;
import io.camunda.optimize.dto.optimize.ProcessInstanceDto;
import io.camunda.optimize.dto.optimize.importing.DecisionInstanceDto;
import io.camunda.optimize.dto.optimize.query.MetadataDto;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.AggregationDto;
import io.camunda.optimize.service.db.DatabaseClient;
import io.camunda.optimize.service.db.repository.IndexRepository;
import io.camunda.optimize.service.db.schema.DatabaseSchemaManager;
import io.camunda.optimize.service.db.schema.DefaultIndexMappingCreator;
import io.camunda.optimize.service.db.schema.ScriptData;
import io.camunda.optimize.service.db.schema.index.IndexMappingCreatorBuilder;
import io.camunda.optimize.service.db.schema.index.VariableUpdateInstanceIndex;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.DatabaseType;
import io.camunda.optimize.service.util.configuration.elasticsearch.DatabaseConnectionNodeConfiguration;
import io.camunda.optimize.service.util.mapper.CustomOffsetDateTimeDeserializer;
import io.camunda.optimize.service.util.mapper.CustomOffsetDateTimeSerializer;
import io.camunda.optimize.test.it.extension.IntegrationTestConfigurationUtil;
import io.camunda.optimize.test.it.extension.MockServerUtil;
import io.camunda.optimize.test.it.extension.db.TermsQueryContainer;
import io.camunda.optimize.test.repository.TestIndexRepository;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.text.StringSubstitutor;
import org.mockserver.integration.ClientAndServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

public abstract class DatabaseTestService {
    protected static final ObjectMapper OBJECT_MAPPER = DatabaseTestService.createObjectMapper();
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseTestService.class);
    protected final String customIndexPrefix;
    protected boolean haveToClean;
    private TestIndexRepository testIndexRepository;

    protected DatabaseTestService(String customIndexPrefix, boolean haveToClean) {
        this.customIndexPrefix = customIndexPrefix;
        this.haveToClean = haveToClean;
    }

    protected static ClientAndServer initMockServer(DatabaseConnectionNodeConfiguration dbConfig) {
        LOG.info("Setting up DB MockServer on port {}", (Object)IntegrationTestConfigurationUtil.getDatabaseMockServerPort());
        return MockServerUtil.createProxyMockServer(dbConfig.getHost(), dbConfig.getHttpPort(), IntegrationTestConfigurationUtil.getDatabaseMockServerPort());
    }

    private static ObjectMapper createObjectMapper() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(OffsetDateTime.class, (JsonSerializer)new CustomOffsetDateTimeSerializer(dateTimeFormatter));
        javaTimeModule.addDeserializer(OffsetDateTime.class, (JsonDeserializer)new CustomOffsetDateTimeDeserializer(dateTimeFormatter));
        return Jackson2ObjectMapperBuilder.json().modules(new Module[]{javaTimeModule}).featuresToDisable(new Object[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE, DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES}).featuresToEnable(new Object[]{JsonParser.Feature.ALLOW_COMMENTS, SerializationFeature.INDENT_OUTPUT}).build();
    }

    public ObjectMapper getObjectMapper() {
        return OBJECT_MAPPER;
    }

    public abstract void beforeEach();

    public abstract void afterEach();

    public abstract ClientAndServer useDBMockServer();

    public abstract void refreshAllOptimizeIndices();

    public abstract void addEntryToDatabase(String var1, String var2, Object var3);

    public abstract void addEntriesToDatabase(String var1, Map<String, Object> var2);

    public abstract <T> List<T> getAllDocumentsOfIndexAs(String var1, Class<T> var2);

    public abstract DatabaseClient getDatabaseClient();

    public abstract Integer getDocumentCountOf(String var1);

    public abstract void deleteAllOptimizeData();

    public abstract void deleteAllIndicesContainingTerm(String var1);

    public abstract void deleteAllSingleProcessReports();

    public abstract void deleteTerminatedSessionsIndex();

    public abstract void deleteAllVariableUpdateInstanceIndices();

    public abstract void deleteAllExternalVariableIndices();

    public abstract void deleteAllZeebeRecordsForPrefix(String var1);

    public abstract void deleteAllOtherZeebeRecordsWithPrefix(String var1, String var2);

    public abstract void updateZeebeRecordsForPrefix(String var1, String var2, String var3);

    public abstract void updateZeebeRecordsWithPositionForPrefix(String var1, String var2, long var3, String var5);

    public abstract void updateZeebeRecordsOfBpmnElementTypeForPrefix(String var1, BpmnElementType var2, String var3);

    public abstract void updateUserTaskDurations(String var1, String var2, long var3);

    public abstract boolean indexExistsCheckWithApplyingOptimizePrefix(String var1);

    public abstract boolean indexExistsCheckWithoutApplyingOptimizePrefix(String var1);

    public abstract OffsetDateTime getLastImportTimestampOfTimestampBasedImportIndex(String var1, String var2);

    public abstract Map<AggregationDto, Double> calculateExpectedValueGivenDurations(Number ... var1);

    public abstract long countRecordsByQuery(TermsQueryContainer var1, String var2);

    public abstract <T> List<T> getZeebeExportedRecordsByQuery(String var1, TermsQueryContainer var2, Class<T> var3);

    public abstract void deleteProcessInstancesFromIndex(String var1, String var2);

    public abstract DatabaseType getDatabaseVendor();

    public abstract void createSnapshot(String var1, String var2, String[] var3);

    public abstract void createRepoSnapshot(String var1);

    public abstract void cleanSnapshots(String var1);

    public abstract List<String> getImportIndices();

    protected abstract <T extends OptimizeDto> List<T> getInstancesById(String var1, List<String> var2, String var3, Class<T> var4);

    public abstract <T> Optional<T> getDatabaseEntryById(String var1, String var2, Class<T> var3);

    public abstract String getDatabaseVersion();

    public abstract int getNestedDocumentsLimit(ConfigurationService var1);

    public abstract void setNestedDocumentsLimit(ConfigurationService var1, int var2);

    public abstract void updateProcessInstanceNestedDocLimit(String var1, int var2, ConfigurationService var3);

    public abstract void createIndex(String var1, String var2) throws IOException;

    public abstract void createIndex(String var1, Map<String, Boolean> var2, DefaultIndexMappingCreator var3) throws IOException;

    public abstract Optional<MetadataDto> readMetadata();

    public void cleanAndVerifyDatabase() {
        try {
            this.refreshAllOptimizeIndices();
            this.deleteAllOptimizeData();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<ProcessInstanceDto> getProcessInstancesById(List<String> instanceIds) {
        return this.getProcessInstancesById("process-instance", instanceIds, ProcessInstanceDto.class);
    }

    public <T extends ProcessInstanceDto> List<T> getProcessInstancesById(String indexName, List<String> instanceIds, Class<T> type) {
        return this.getInstancesById(indexName, instanceIds, "processInstanceId", type);
    }

    public List<DecisionInstanceDto> getDecisionInstancesById(List<String> instanceIds) {
        return this.getDecisionInstancesById("decision-instance", instanceIds, DecisionInstanceDto.class);
    }

    protected void setTestIndexRepository(TestIndexRepository testIndexRepository) {
        this.testIndexRepository = testIndexRepository;
    }

    public <T extends DecisionInstanceDto> List<T> getDecisionInstancesById(String indexName, List<String> instanceIds, Class<T> type) {
        return this.getInstancesById(indexName, instanceIds, "decisionInstanceId", type);
    }

    protected String buildUpdateScript(long duration) {
        StringSubstitutor substitutor = new StringSubstitutor((Map)ImmutableMap.builder().put((Object)"flowNodesField", (Object)"flowNodeInstances").put((Object)"flowNodeTypeField", (Object)"flowNodeType").put((Object)"totalDurationField", (Object)"totalDurationInMs").put((Object)"idleDurationField", (Object)"idleDurationInMs").put((Object)"workDurationField", (Object)"workDurationInMs").put((Object)"userTaskFlowNodeType", (Object)"userTask").put((Object)"newDuration", (Object)String.valueOf(duration)).build());
        String updateScript = substitutor.replace("for (def flowNode : ctx._source.${flowNodesField}) {if (flowNode.${flowNodeTypeField}.equals(\"${userTaskFlowNodeType}\")) {flowNode.${totalDurationField} = ${newDuration};flowNode.${workDurationField} = ${newDuration};flowNode.${idleDurationField} = ${newDuration};}}");
        return updateScript;
    }

    public void createMissingIndices(IndexMappingCreatorBuilder indexMappingCreatorBuilder, Set<String> aliases, Set<String> aKey) {
        ((IndexRepository)ApplicationContextProvider.getBean(IndexRepository.class)).createMissingIndices(indexMappingCreatorBuilder, aliases, aKey);
    }

    public abstract void setActivityStartDatesToNull(String var1, ScriptData var2);

    public abstract void setUserTaskDurationToNull(String var1, String var2, ScriptData var3);

    public abstract Long getImportedActivityCount();

    public abstract List<String> getAllIndicesWithWriteAlias(String var1);

    public abstract VariableUpdateInstanceIndex getVariableUpdateInstanceIndex();

    public abstract void deleteAllDocumentsInIndex(String var1);

    public abstract void insertTestDocuments(int var1, String var2, String var3) throws IOException;

    public abstract void performLowLevelBulkRequest(String var1, String var2, String var3) throws IOException;

    public abstract void initSchema(DatabaseSchemaManager var1);

    public abstract Map<String, ? extends Object> getMappingFields(String var1) throws IOException;

    public abstract boolean indexExists(String var1, Boolean var2);

    public abstract boolean templateExists(String var1) throws IOException;

    public abstract boolean isAliasReadOnly(String var1) throws IOException;

    public abstract List<String> getAllIndicesWithReadOnlyAlias(String var1);
}

