/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.test.it.extension;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.camunda.optimize.ApplicationContextProvider;
import io.camunda.optimize.OptimizeRequestExecutor;
import io.camunda.optimize.exception.OptimizeIntegrationTestException;
import io.camunda.optimize.service.alert.AlertService;
import io.camunda.optimize.service.db.DatabaseClient;
import io.camunda.optimize.service.db.schema.DatabaseMetadataService;
import io.camunda.optimize.service.db.schema.OptimizeIndexNameService;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.importing.AbstractImportScheduler;
import io.camunda.optimize.service.importing.ImportIndexHandlerRegistry;
import io.camunda.optimize.service.importing.ImportSchedulerManagerService;
import io.camunda.optimize.service.importing.PositionBasedImportIndexHandler;
import io.camunda.optimize.service.importing.ingested.mediator.StoreIngestedImportProgressMediator;
import io.camunda.optimize.service.importing.zeebe.ZeebeImportScheduler;
import io.camunda.optimize.service.importing.zeebe.mediator.StorePositionBasedImportProgressMediator;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.service.util.configuration.ConfigurationReloadable;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.test.it.extension.IntegrationTestConfigurationUtil;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.junit.jupiter.SpringExtension;

public class EmbeddedOptimizeExtension
implements BeforeEachCallback,
AfterEachCallback,
BeforeAllCallback,
AfterAllCallback {
    private static final ObjectMapper configObjectMapper = new ObjectMapper().registerModules(new Module[]{new JavaTimeModule(), new Jdk8Module()});
    private static String serializedDefaultConfiguration;
    private static final Logger LOG;
    private final boolean beforeAllMode;
    private ApplicationContext applicationContext;
    private OptimizeRequestExecutor requestExecutor;
    private boolean resetImportOnStart = true;
    private boolean closeContextAfterTest = false;

    public EmbeddedOptimizeExtension() {
        this(false);
    }

    public EmbeddedOptimizeExtension(boolean beforeAllMode) {
        LOG.info("Running tests with database {}", (Object)IntegrationTestConfigurationUtil.getDatabaseType());
        System.setProperty("CAMUNDA_OPTIMIZE_DATABASE", IntegrationTestConfigurationUtil.getDatabaseType().getId());
        this.beforeAllMode = beforeAllMode;
    }

    public void beforeAll(ExtensionContext extensionContext) {
        this.setApplicationContext(SpringExtension.getApplicationContext((ExtensionContext)extensionContext));
        if (serializedDefaultConfiguration == null) {
            try {
                serializedDefaultConfiguration = configObjectMapper.writeValueAsString((Object)this.getConfigurationService());
            }
            catch (JsonProcessingException e) {
                throw new OptimizeRuntimeException((Throwable)e);
            }
        }
        if (this.beforeAllMode) {
            this.setupOptimize();
        }
    }

    public void beforeEach(ExtensionContext extensionContext) {
        this.setApplicationContext(SpringExtension.getApplicationContext((ExtensionContext)extensionContext));
        this.initMetadataIfMissing();
        if (!this.beforeAllMode) {
            this.setupOptimize();
        }
    }

    public void afterAll(ExtensionContext extensionContext) {
        if (this.beforeAllMode) {
            this.afterTest();
        }
    }

    public void afterEach(ExtensionContext extensionContext) {
        if (!this.beforeAllMode) {
            this.afterTest();
        }
        if (this.closeContextAfterTest) {
            ((ConfigurableApplicationContext)this.applicationContext).close();
            this.setCloseContextAfterTest(false);
            this.setApplicationContext(SpringExtension.getApplicationContext((ExtensionContext)extensionContext));
            this.reloadConfiguration();
        }
    }

    public void setupOptimize() {
        try {
            this.requestExecutor = new OptimizeRequestExecutor("demo", "demo", IntegrationTestConfigurationUtil.getEmbeddedOptimizeRestApiEndpoint(this.applicationContext)).initAuthCookie();
            if (this.isResetImportOnStart()) {
                this.resetPositionBasedImportStartIndexes();
                this.setResetImportOnStart(true);
            }
        }
        catch (Exception e) {
            String message = "Failed starting embedded Optimize.";
            LOG.error("Failed starting embedded Optimize.", (Throwable)e);
            throw new OptimizeIntegrationTestException("Failed starting embedded Optimize.", e);
        }
    }

    public void afterTest() {
        try {
            this.getAlertService().getScheduler().clear();
            this.stopImportScheduling();
            this.resetConfiguration();
            LocalDateUtil.reset();
            this.reloadConfiguration();
        }
        catch (Exception e) {
            LOG.error("Failed to clean up after test", (Throwable)e);
        }
    }

    public void stopImportScheduling() {
        this.getImportSchedulerManager().stopSchedulers();
    }

    public void importAllZeebeEntitiesFromScratch() {
        try {
            this.resetPositionBasedImportStartIndexes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.importAllZeebeEntitiesFromLastIndex();
    }

    public void importAllZeebeEntitiesFromLastIndex() {
        try {
            ((ZeebeImportScheduler)this.getImportSchedulerManager().getZeebeImportScheduler().orElseThrow(() -> new OptimizeIntegrationTestException("No Zeebe Scheduler present"))).runImportRound(true).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
    }

    public void storeImportIndexesToElasticsearch() {
        ArrayList<CompletableFuture> synchronizationCompletables = new ArrayList<CompletableFuture>();
        List importSchedulers = this.getImportSchedulerManager().getImportSchedulers().stream().filter(scheduler -> this.getConfigurationService().isImportEnabled(scheduler.getDataImportSourceDto())).collect(Collectors.toList());
        for (AbstractImportScheduler scheduler2 : importSchedulers) {
            synchronizationCompletables.addAll(scheduler2.getImportMediators().stream().filter(med -> med instanceof StoreIngestedImportProgressMediator || med instanceof StorePositionBasedImportProgressMediator).map(mediator -> {
                mediator.resetBackoff();
                return mediator.runImport();
            }).toList());
        }
        CompletableFuture.allOf(synchronizationCompletables.toArray(new CompletableFuture[0])).join();
    }

    public ImportSchedulerManagerService getImportSchedulerManager() {
        return this.getBean(ImportSchedulerManagerService.class);
    }

    public OptimizeRequestExecutor getRequestExecutor() {
        return this.requestExecutor;
    }

    public void initMetadataIfMissing() {
        this.getDatabaseMetadataService().initMetadataIfMissing(this.getOptimizeDatabaseClient());
    }

    public void reloadConfiguration() {
        Map refreshableServices = this.getApplicationContext().getBeansOfType(ConfigurationReloadable.class);
        for (Map.Entry entry : refreshableServices.entrySet()) {
            Object beanRef = entry.getValue();
            if (!(beanRef instanceof ConfigurationReloadable)) continue;
            ConfigurationReloadable reloadable = (ConfigurationReloadable)beanRef;
            reloadable.reloadConfiguration(this.getApplicationContext());
        }
        this.getOptimizeDatabaseClient().setDefaultRequestOptions();
    }

    public void resetConfiguration() throws IOException {
        LOG.info("resetting config, parsing defaultconfig and copying properties");
        BeanUtils.copyProperties((Object)configObjectMapper.readValue(serializedDefaultConfiguration, ConfigurationService.class), (Object)this.getBean(ConfigurationService.class));
        LOG.info("done resetting config");
    }

    public void resetPositionBasedImportStartIndexes() {
        this.getAllPositionBasedImportHandlers().forEach(PositionBasedImportIndexHandler::resetImportIndex);
    }

    public List<PositionBasedImportIndexHandler> getAllPositionBasedImportHandlers() {
        LinkedList<PositionBasedImportIndexHandler> positionBasedHandlers = new LinkedList<PositionBasedImportIndexHandler>();
        for (int partitionId = 1; partitionId <= this.getConfigurationService().getConfiguredZeebe().getPartitionCount(); ++partitionId) {
            positionBasedHandlers.addAll(this.getIndexHandlerRegistry().getPositionBasedHandlers(Integer.valueOf(partitionId)));
        }
        return positionBasedHandlers;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        ((ApplicationContextProvider)applicationContext.getBean(ApplicationContextProvider.class)).setApplicationContext(applicationContext);
    }

    public <T> T getBean(Class<T> clazz) {
        return (T)this.applicationContext.getBean(clazz);
    }

    public DateTimeFormatter getDateTimeFormatter() {
        return this.getBean(DateTimeFormatter.class);
    }

    public ConfigurationService getConfigurationService() {
        return this.getBean(ConfigurationService.class);
    }

    public ImportIndexHandlerRegistry getIndexHandlerRegistry() {
        return this.getBean(ImportIndexHandlerRegistry.class);
    }

    public AlertService getAlertService() {
        return this.getBean(AlertService.class);
    }

    public OptimizeIndexNameService getIndexNameService() {
        return this.getBean(OptimizeIndexNameService.class);
    }

    public DatabaseClient getOptimizeDatabaseClient() {
        return this.getBean(DatabaseClient.class);
    }

    public DatabaseMetadataService getDatabaseMetadataService() {
        return this.getBean(DatabaseMetadataService.class);
    }

    private boolean isResetImportOnStart() {
        return this.resetImportOnStart;
    }

    public void setResetImportOnStart(boolean resetImportOnStart) {
        this.resetImportOnStart = resetImportOnStart;
    }

    public String format(OffsetDateTime offsetDateTime) {
        return this.getDateTimeFormatter().format(offsetDateTime);
    }

    public boolean isCloseContextAfterTest() {
        return this.closeContextAfterTest;
    }

    public void setCloseContextAfterTest(boolean closeContextAfterTest) {
        this.closeContextAfterTest = closeContextAfterTest;
    }

    static {
        LOG = LoggerFactory.getLogger(EmbeddedOptimizeExtension.class);
    }
}

