/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.ReportType;
import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.combined.CombinedReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.SingleDecisionReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.BooleanVariableFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.data.BooleanVariableFilterSubDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.SingleProcessReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ProcessFilterDto;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.ConfigurationServiceBuilder;
import io.camunda.optimize.service.util.mapper.ObjectMapperFactory;
import io.camunda.optimize.service.util.mapper.OptimizeDateTimeFormatterFactory;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class ObjectMapperFactoryTest {
    private ConfigurationService configurationService;
    private ObjectMapperFactory objectMapperFactory;

    @BeforeEach
    public void init() {
        this.configurationService = ConfigurationServiceBuilder.createConfiguration().loadConfigurationFrom(new String[]{"service-config.yaml"}).build();
        this.objectMapperFactory = new ObjectMapperFactory(new OptimizeDateTimeFormatterFactory().getObject(), this.configurationService);
    }

    @Test
    public void testNoFailOnMissingReportDataAlthoughReportTypeSet() throws Exception {
        ReportDefinitionDto reportDefinitionDto = (ReportDefinitionDto)this.createOptimizeMapper().readValue(ObjectMapperFactoryTest.class.getResourceAsStream("/test/data/single-process-report-definition-create-request.json"), ReportDefinitionDto.class);
        Assertions.assertThat((boolean)reportDefinitionDto.isCombined()).isFalse();
        Assertions.assertThat((Comparable)reportDefinitionDto.getReportType()).isEqualTo((Object)ReportType.PROCESS);
        ((ObjectAssert)Assertions.assertThat((Object)reportDefinitionDto).isInstanceOf(SingleProcessReportDefinitionRequestDto.class)).satisfies(new ThrowingConsumer[]{processDefinition -> Assertions.assertThat((Object)processDefinition.getData()).isNotNull()});
    }

    @Test
    public void testCanDeserializeToSingleProcessReport() throws Exception {
        SingleProcessReportDefinitionRequestDto reportDefinitionDto = (SingleProcessReportDefinitionRequestDto)this.createOptimizeMapper().readValue(ObjectMapperFactoryTest.class.getResourceAsStream("/test/data/single-process-report-definition-create-request.json"), SingleProcessReportDefinitionRequestDto.class);
        Assertions.assertThat((boolean)reportDefinitionDto.isCombined()).isFalse();
        Assertions.assertThat((Comparable)reportDefinitionDto.getReportType()).isEqualTo((Object)ReportType.PROCESS);
        Assertions.assertThat((Object)reportDefinitionDto).isInstanceOf(SingleProcessReportDefinitionRequestDto.class);
    }

    @Test
    public void testCanDeserializeToSingleDecisionReport() throws Exception {
        SingleDecisionReportDefinitionRequestDto reportDefinitionDto = (SingleDecisionReportDefinitionRequestDto)this.createOptimizeMapper().readValue(ObjectMapperFactoryTest.class.getResourceAsStream("/test/data/single-decision-report-definition-create-request.json"), SingleDecisionReportDefinitionRequestDto.class);
        Assertions.assertThat((boolean)reportDefinitionDto.isCombined()).isFalse();
        Assertions.assertThat((Comparable)reportDefinitionDto.getReportType()).isEqualTo((Object)ReportType.DECISION);
        Assertions.assertThat((Object)reportDefinitionDto).isInstanceOf(SingleDecisionReportDefinitionRequestDto.class);
    }

    @Test
    public void testCanDeserializeToCombinedProcessReport() throws Exception {
        CombinedReportDefinitionRequestDto reportDefinitionDto = (CombinedReportDefinitionRequestDto)this.createOptimizeMapper().readValue(ObjectMapperFactoryTest.class.getResourceAsStream("/test/data/combined-process-report-definition-create-request.json"), CombinedReportDefinitionRequestDto.class);
        Assertions.assertThat((boolean)reportDefinitionDto.isCombined()).isTrue();
        Assertions.assertThat((Comparable)reportDefinitionDto.getReportType()).isEqualTo((Object)ReportType.PROCESS);
        Assertions.assertThat((Object)reportDefinitionDto).isInstanceOf(CombinedReportDefinitionRequestDto.class);
    }

    @Test
    public void testFilterSerialization() throws Exception {
        ProcessReportDataDto data = (ProcessReportDataDto)this.createOptimizeMapper().readValue(ObjectMapperFactoryTest.class.getResourceAsStream("/test/data/filter_request.json"), ProcessReportDataDto.class);
        Assertions.assertThat((List)((BooleanVariableFilterSubDataDto)((BooleanVariableFilterDataDto)((ProcessFilterDto)data.getFilter().get(0)).getData()).getData()).getValues()).containsExactly((Object[])new Boolean[]{true});
        data = (ProcessReportDataDto)this.createOptimizeMapper().readValue(ObjectMapperFactoryTest.class.getResourceAsStream("/test/data/filter_request_single.json"), ProcessReportDataDto.class);
        Assertions.assertThat((List)((BooleanVariableFilterSubDataDto)((BooleanVariableFilterDataDto)((ProcessFilterDto)data.getFilter().get(0)).getData()).getData()).getValues()).containsExactly((Object[])new Boolean[]{true});
    }

    @Test
    public void testFilterSerializationWithLowercaseType() throws Exception {
        ProcessReportDataDto data = (ProcessReportDataDto)this.createOptimizeMapper().readValue(ObjectMapperFactoryTest.class.getResourceAsStream("/test/data/filter_request_lowercase_type.json"), ProcessReportDataDto.class);
        Assertions.assertThat((List)((BooleanVariableFilterSubDataDto)((BooleanVariableFilterDataDto)((ProcessFilterDto)data.getFilter().get(0)).getData()).getData()).getValues()).containsExactly((Object[])new Boolean[]{true});
        data = (ProcessReportDataDto)this.createOptimizeMapper().readValue(ObjectMapperFactoryTest.class.getResourceAsStream("/test/data/filter_request_single.json"), ProcessReportDataDto.class);
        Assertions.assertThat((List)((BooleanVariableFilterSubDataDto)((BooleanVariableFilterDataDto)((ProcessFilterDto)data.getFilter().get(0)).getData()).getData()).getValues()).containsExactly((Object[])new Boolean[]{true});
    }

    @Test
    public void testOptimizeMapperDateSerialization() throws Exception {
        String dateString = "2017-12-11T17:28:38.222+0100";
        DateHolder instance = new DateHolder();
        instance.setDate(OffsetDateTime.parse("2017-12-11T17:28:38.222+0100", this.createEngineDateFormatter()));
        String parsedString = this.createOptimizeMapper().writeValueAsString((Object)instance);
        Assertions.assertThat((String)parsedString).contains(new CharSequence[]{"2017-12-11T17:28:38.222+0100"});
    }

    @Test
    public void testOptimizeMapperDateDeserialization() throws Exception {
        String dateString = "2017-12-11T17:28:38.222+0100";
        OffsetDateTime expectedOffsetDateTime = OffsetDateTime.parse("2017-12-11T17:28:38.222+0100", this.createEngineDateFormatter());
        OffsetDateTime parsedOffsetDateTime = ((DateHolder)this.createOptimizeMapper().readValue(this.createDateHolderJsonString("2017-12-11T17:28:38.222+0100"), DateHolder.class)).getDate();
        Assertions.assertThat((OffsetDateTime)parsedOffsetDateTime).isEqualTo((Object)expectedOffsetDateTime);
    }

    @Test
    public void testEngineMapperDateSerialization() throws Exception {
        String dateString = "2017-12-11T17:28:38.222+0100";
        DateHolder instance = new DateHolder();
        instance.setDate(OffsetDateTime.parse("2017-12-11T17:28:38.222+0100", this.createEngineDateFormatter()));
        String parsedString = this.createEngineMapper().writeValueAsString((Object)instance);
        Assertions.assertThat((String)parsedString).contains(new CharSequence[]{"2017-12-11T17:28:38.222+0100"});
    }

    @Test
    public void testEngineMapperDateDeserialization() throws JsonProcessingException {
        String dateString = "2017-12-11T17:28:38.222+0100";
        OffsetDateTime expectedOffsetDateTime = OffsetDateTime.parse("2017-12-11T17:28:38.222+0100", this.createEngineDateFormatter());
        OffsetDateTime parsedOffsetDateTime = ((DateHolder)this.createEngineMapper().readValue(this.createDateHolderJsonString("2017-12-11T17:28:38.222+0100"), DateHolder.class)).getDate();
        Assertions.assertThat((OffsetDateTime)parsedOffsetDateTime).isEqualTo((Object)expectedOffsetDateTime);
    }

    @Test
    public void testEngineMapperDateDeserializationFromStringWithoutMillisAndTimezone() throws JsonProcessingException {
        String datePattern = "yyyy-MM-dd'T'HH:mm:ss";
        this.configurationService.setEngineDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        String dateString = "2017-12-11T17:28:38";
        OffsetDateTime expectedOffsetDateTime = LocalDateTime.parse("2017-12-11T17:28:38", this.createEngineDateFormatter()).atZone(ZoneId.systemDefault()).toOffsetDateTime();
        OffsetDateTime parsedOffsetDateTime = ((DateHolder)this.createEngineMapper().readValue(this.createDateHolderJsonString("2017-12-11T17:28:38"), DateHolder.class)).getDate();
        Assertions.assertThat((OffsetDateTime)parsedOffsetDateTime).isEqualTo((Object)expectedOffsetDateTime);
    }

    private DateTimeFormatter createEngineDateFormatter() {
        return DateTimeFormatter.ofPattern(this.configurationService.getEngineDateFormat());
    }

    private ObjectMapper createEngineMapper() {
        return this.objectMapperFactory.createEngineMapper();
    }

    private ObjectMapper createOptimizeMapper() {
        return this.objectMapperFactory.createOptimizeMapper();
    }

    private String createDateHolderJsonString(String dateString) {
        return "{\"date\": \"" + dateString + "\"}";
    }

    static class DateHolder {
        private OffsetDateTime date;

        DateHolder() {
        }

        public OffsetDateTime getDate() {
            return this.date.truncatedTo(ChronoUnit.MILLIS);
        }

        public void setDate(OffsetDateTime date) {
            this.date = date;
        }
    }
}

