/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.uiconfiguration;

import io.camunda.identity.sdk.Identity;
import io.camunda.identity.sdk.users.Users;
import io.camunda.optimize.dto.optimize.query.ui_configuration.UIConfigurationResponseDto;
import io.camunda.optimize.license.LicenseType;
import io.camunda.optimize.rest.cloud.CloudSaasMetaInfoService;
import io.camunda.optimize.service.CamundaLicenseService;
import io.camunda.optimize.service.SettingsService;
import io.camunda.optimize.service.UIConfigurationService;
import io.camunda.optimize.service.exceptions.OptimizeConfigurationException;
import io.camunda.optimize.service.metadata.OptimizeVersionService;
import io.camunda.optimize.service.tenant.TenantService;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.DatabaseType;
import io.camunda.optimize.service.util.configuration.OptimizeProfile;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Answers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.springframework.core.env.Environment;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.LENIENT)
public class UIConfigurationServiceTest {
    private static OffsetDateTime testDate;
    private static final String TEST_DATE_STRING = "2024-10-29T15:14:13Z";
    @InjectMocks
    UIConfigurationService underTest;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ConfigurationService configurationService;
    @Mock
    private OptimizeVersionService versionService;
    @Mock
    private TenantService tenantService;
    @Mock
    private CamundaLicenseService camundaLicenseService;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private SettingsService settingService;
    @Mock
    private Environment environment;
    @Mock
    private Optional<CloudSaasMetaInfoService> metaInfoService = Optional.empty();
    @Mock
    private Identity identity;
    @Mock
    private Users identityUsers;

    private static Stream<Arguments> optimizeProfiles() {
        return Stream.of(Arguments.of((Object[])new Object[]{"cloud"}), Arguments.of((Object[])new Object[]{"ccsm"}));
    }

    private static Stream<Arguments> optimizeProfilesAndExpectedIsEnterpriseModeResult() {
        return Stream.of(Arguments.of((Object[])new Object[]{"cloud", true}), Arguments.of((Object[])new Object[]{"ccsm", false}));
    }

    @BeforeAll
    public static void beforeAll() {
        testDate = OffsetDateTime.parse(TEST_DATE_STRING);
    }

    @ParameterizedTest
    @MethodSource(value={"optimizeProfiles"})
    public void testProfileReadCorrectly(String activeProfile) {
        this.initializeMocks();
        Mockito.when((Object)this.environment.getActiveProfiles()).thenReturn((Object)new String[]{activeProfile});
        UIConfigurationResponseDto configurationResponse = this.underTest.getUIConfiguration();
        Assertions.assertThat((Comparable)configurationResponse.getOptimizeProfile()).isEqualTo((Object)OptimizeProfile.toProfile((String)activeProfile));
    }

    @Test
    public void testDefaultProfileUsed() {
        this.initializeMocks();
        Mockito.when((Object)this.environment.getActiveProfiles()).thenReturn((Object)new String[0]);
        UIConfigurationResponseDto configurationResponse = this.underTest.getUIConfiguration();
        Assertions.assertThat((Comparable)configurationResponse.getOptimizeProfile()).isEqualTo((Object)OptimizeProfile.CCSM);
    }

    @Test
    public void testMultipleProfilesDoesNotWork() {
        this.initializeMocks();
        Mockito.when((Object)this.environment.getActiveProfiles()).thenReturn((Object)new String[]{"cloud", "ccsm"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.underTest.getUIConfiguration()).isInstanceOf(OptimizeConfigurationException.class)).hasMessage("Cannot configure more than one Optimize profile");
    }

    @Test
    public void testUnknownProfileUsesDefault() {
        this.initializeMocks();
        Mockito.when((Object)this.environment.getActiveProfiles()).thenReturn((Object)new String[]{"someUnknownProfile"});
        UIConfigurationResponseDto configurationResponse = this.underTest.getUIConfiguration();
        Assertions.assertThat((Comparable)configurationResponse.getOptimizeProfile()).isEqualTo((Object)OptimizeProfile.CCSM);
    }

    @ParameterizedTest
    @MethodSource(value={"optimizeProfilesAndExpectedIsEnterpriseModeResult"})
    public void testIsEnterpriseModeDeterminedCorrectly(String activeProfile, boolean expectedIsEnterprise) {
        this.initializeMocks();
        Mockito.when((Object)this.environment.getActiveProfiles()).thenReturn((Object)new String[]{activeProfile});
        UIConfigurationResponseDto configurationResponse = this.underTest.getUIConfiguration();
        Assertions.assertThat((boolean)configurationResponse.isEnterpriseMode()).isEqualTo(expectedIsEnterprise);
    }

    @Test
    public void testMaximumNumberOfDataSourcesForReportIsReturned() {
        this.initializeMocks();
        Mockito.when((Object)this.environment.getActiveProfiles()).thenReturn((Object)new String[]{"cloud"});
        Mockito.when((Object)this.configurationService.getUiConfiguration().getMaxNumDataSourcesForReport()).thenReturn((Object)50);
        UIConfigurationResponseDto configurationResponse = this.underTest.getUIConfiguration();
        Assertions.assertThat((int)configurationResponse.getMaxNumDataSourcesForReport()).isEqualTo(50);
    }

    @Test
    public void testCamundaLicenseInformationIsReturned() {
        this.initializeMocks();
        Mockito.when((Object)this.environment.getActiveProfiles()).thenReturn((Object)new String[]{"cloud"});
        UIConfigurationResponseDto configurationResponse = this.underTest.getUIConfiguration();
        Assertions.assertThat((String)configurationResponse.getLicenseType()).isEqualTo("saas");
        Assertions.assertThat((boolean)configurationResponse.isValidLicense()).isEqualTo(true);
        Assertions.assertThat((boolean)configurationResponse.isCommercial()).isEqualTo(false);
        Assertions.assertThat((String)configurationResponse.getExpiresAt()).isEqualTo(TEST_DATE_STRING);
    }

    @Test
    public void testCamundaLicenseReturnsNullWhenThereIsNoExpiration() {
        this.initializeMocks();
        Mockito.when((Object)this.environment.getActiveProfiles()).thenReturn((Object)new String[]{"cloud"});
        Mockito.when((Object)this.camundaLicenseService.getCamundaLicenseExpiresAt()).thenReturn(null);
        UIConfigurationResponseDto configurationResponse = this.underTest.getUIConfiguration();
        Assertions.assertThat((String)configurationResponse.getLicenseType()).isEqualTo("saas");
        Assertions.assertThat((boolean)configurationResponse.isValidLicense()).isEqualTo(true);
        Assertions.assertThat((boolean)configurationResponse.isCommercial()).isEqualTo(false);
        Assertions.assertThat((String)configurationResponse.getExpiresAt()).isEqualTo(null);
    }

    private void initializeMocks() {
        Mockito.when((Object)this.configurationService.getConfiguredWebhooks()).thenReturn(Collections.emptyMap());
        Mockito.when((Object)this.identity.users()).thenReturn((Object)this.identityUsers);
        Mockito.when((Object)this.identityUsers.isAvailable()).thenReturn((Object)true);
        Mockito.when((Object)this.environment.getProperty("CAMUNDA_OPTIMIZE_DATABASE", "elasticsearch")).thenReturn((Object)DatabaseType.ELASTICSEARCH.toString());
        Mockito.when((Object)this.camundaLicenseService.getCamundaLicenseType()).thenReturn((Object)LicenseType.SAAS);
        Mockito.when((Object)this.camundaLicenseService.isCamundaLicenseValid()).thenReturn((Object)true);
        Mockito.when((Object)this.camundaLicenseService.isCommercialCamundaLicense()).thenReturn((Object)false);
        Mockito.when((Object)this.camundaLicenseService.getCamundaLicenseExpiresAt()).thenReturn((Object)testDate);
    }
}

