/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.security;

import io.camunda.optimize.service.security.AuthCookieService;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.security.AuthConfiguration;
import io.camunda.optimize.service.util.configuration.security.CloudAuthConfiguration;
import io.camunda.optimize.service.util.configuration.security.CookieConfiguration;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.security.oauth2.core.OAuth2AccessToken;

@ExtendWith(value={MockitoExtension.class})
public class AuthCookieServiceTest {
    @Mock
    ConfigurationService configurationService;
    @Mock
    OAuth2AccessToken oAuth2AccessToken;

    @Test
    public void getTokenFromContainerRequestContext() {
        String authorizationHeader = String.format("Bearer %s", "test");
        Cookie cookie = new Cookie("X-Optimize-Authorization", authorizationHeader);
        Cookie[] cookies = new Cookie[]{cookie};
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)requestMock.getCookies()).thenReturn((Object)cookies);
        Optional token = AuthCookieService.getAuthCookieToken((HttpServletRequest)requestMock);
        ((OptionalAssert)Assertions.assertThat((Optional)token).isPresent()).get().isEqualTo((Object)"test");
    }

    @Test
    public void getTokenExceptionFromContainerRequestContext() {
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Assertions.assertThat((Optional)AuthCookieService.getAuthCookieToken((HttpServletRequest)requestMock)).isEmpty();
    }

    @Test
    public void getTokenFromHttpServletRequest() {
        String authorizationHeader = String.format("Bearer %s", "test");
        Cookie[] cookies = new Cookie[]{new Cookie("X-Optimize-Authorization", authorizationHeader)};
        HttpServletRequest servletRequestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)servletRequestMock.getCookies()).thenReturn((Object)cookies);
        Optional token = AuthCookieService.getAuthCookieToken((HttpServletRequest)servletRequestMock);
        ((OptionalAssert)Assertions.assertThat((Optional)token).isPresent()).get().isEqualTo((Object)"test");
    }

    @Test
    public void getTokenExceptionFromHttpServletRequest() {
        HttpServletRequest servletRequestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Assertions.assertThat((Optional)AuthCookieService.getAuthCookieToken((HttpServletRequest)servletRequestMock)).isEmpty();
    }

    @ParameterizedTest
    @MethodSource(value={"tokenAndExpectedCookieValues"})
    public void createServiceTokenCookies(String serviceTokenValue, List<String> expectedCookieValues) {
        CookieConfiguration cookieConfig = new CookieConfiguration();
        cookieConfig.setMaxSize(Integer.valueOf(2));
        CloudAuthConfiguration cloudAuthConfig = new CloudAuthConfiguration();
        cloudAuthConfig.setClientId("clusterId");
        AuthConfiguration authConfig = new AuthConfiguration();
        authConfig.setCookieConfiguration(cookieConfig);
        authConfig.setCloudAuthConfiguration(cloudAuthConfig);
        Mockito.when((Object)this.configurationService.getAuthConfiguration()).thenReturn((Object)authConfig);
        Mockito.when((Object)this.oAuth2AccessToken.getTokenValue()).thenReturn((Object)serviceTokenValue);
        AuthCookieService authCookieService = new AuthCookieService(this.configurationService);
        List cookies = authCookieService.createOptimizeServiceTokenCookies(this.oAuth2AccessToken, Instant.now(), "http");
        Assertions.assertThat((List)cookies).extracting(Cookie::getValue).containsExactlyElementsOf(expectedCookieValues);
    }

    @ParameterizedTest
    @MethodSource(value={"tokenAndExpectedCookieValues"})
    public void extractServiceTokenFromCookies(String expectedServiceTokenValue, List<String> cookieValues) {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        for (int i = 0; i < cookieValues.size(); ++i) {
            cookies.add(new Cookie("X-Optimize-Service-Token_" + i, cookieValues.get(i)));
        }
        HttpServletRequest servletRequestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)servletRequestMock.getCookies()).thenReturn((Object)((Cookie[])cookies.toArray(Cookie[]::new)));
        Optional serviceAccessToken = AuthCookieService.getServiceAccessToken((HttpServletRequest)servletRequestMock);
        ((OptionalAssert)Assertions.assertThat((Optional)serviceAccessToken).isPresent()).get().isEqualTo((Object)expectedServiceTokenValue);
    }

    private static Stream<Arguments> tokenAndExpectedCookieValues() {
        return Stream.of(Arguments.of((Object[])new Object[]{"a", List.of("a")}), Arguments.of((Object[])new Object[]{"bc", List.of("bc")}), Arguments.of((Object[])new Object[]{"def", List.of("de", "f")}), Arguments.of((Object[])new Object[]{"ghij", List.of("gh", "ij")}));
    }
}

