/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing;

import io.camunda.client.api.response.ProcessInstanceEvent;
import io.camunda.optimize.AbstractCCSMIT;
import io.camunda.optimize.dto.optimize.ProcessInstanceDto;
import io.camunda.optimize.dto.optimize.persistence.incident.IncidentDto;
import io.camunda.optimize.dto.optimize.persistence.incident.IncidentStatus;
import io.camunda.optimize.dto.optimize.persistence.incident.IncidentType;
import io.camunda.optimize.dto.optimize.query.process.FlowNodeInstanceDto;
import io.camunda.optimize.dto.zeebe.ZeebeRecordDto;
import io.camunda.optimize.dto.zeebe.incident.ZeebeIncidentDataDto;
import io.camunda.optimize.dto.zeebe.incident.ZeebeIncidentRecordDto;
import io.camunda.optimize.exception.OptimizeIntegrationTestException;
import io.camunda.optimize.test.it.extension.db.TermsQueryContainer;
import io.camunda.optimize.util.ZeebeBpmnModels;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIf;
import org.junit.jupiter.api.condition.EnabledIf;

public class ZeebeIncidentImportIT
extends AbstractCCSMIT {
    @Test
    public void importZeebeIncidentData_openFailTaskIncident() {
        ProcessInstanceEvent deployedInstance = this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createSimpleServiceTaskProcess("someProcess"));
        zeebeExtension.failTask("service_task");
        this.waitUntilIncidentRecordWithProcessIdExported("someProcess");
        this.importAllZeebeEntitiesFromScratch();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{savedInstance -> {
            Assertions.assertThat((String)savedInstance.getProcessInstanceId()).isEqualTo(String.valueOf(deployedInstance.getProcessInstanceKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionId()).isEqualTo(String.valueOf(deployedInstance.getProcessDefinitionKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionKey()).isEqualTo(deployedInstance.getBpmnProcessId());
            Assertions.assertThat((String)savedInstance.getProcessDefinitionVersion()).isEqualTo(String.valueOf(deployedInstance.getVersion()));
            Assertions.assertThat((String)savedInstance.getDataSource().getName()).isEqualTo(this.getConfiguredZeebeName());
            Assertions.assertThat((String)savedInstance.getState()).isEqualTo("ACTIVE");
            Assertions.assertThat((String)savedInstance.getBusinessKey()).isNull();
            Assertions.assertThat((List)savedInstance.getFlowNodeInstances()).isNotEmpty();
            Assertions.assertThat((List)savedInstance.getVariables()).isEmpty();
            Assertions.assertThat((OffsetDateTime)savedInstance.getStartDate()).isNotNull();
            Assertions.assertThat((OffsetDateTime)savedInstance.getEndDate()).isNull();
            Assertions.assertThat((Long)savedInstance.getDuration()).isNull();
            ((ListAssert)((ListAssert)Assertions.assertThat((List)savedInstance.getIncidents()).isNotEmpty()).hasSize(1)).containsExactly((Object[])new IncidentDto[]{this.createIncident((ProcessInstanceDto)savedInstance, deployedInstance, "service_task", IncidentStatus.OPEN)});
        }});
    }

    @Test
    public void importZeebeIncidentData_throwErrorIncident() {
        ProcessInstanceEvent deployedInstance = this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createSimpleServiceTaskProcess("someProcess"));
        zeebeExtension.throwErrorIncident("service_task");
        this.waitUntilIncidentRecordWithProcessIdExported("someProcess");
        this.importAllZeebeEntitiesFromScratch();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{savedInstance -> ((ListAssert)((ListAssert)Assertions.assertThat((List)savedInstance.getIncidents()).isNotEmpty()).hasSize(1)).containsExactly((Object[])new IncidentDto[]{this.createIncident((ProcessInstanceDto)savedInstance, deployedInstance, "service_task", IncidentStatus.OPEN)})});
    }

    @Test
    public void importZeebeIncidentData_missingVariableIncident() {
        ProcessInstanceEvent deployedInstance = this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createIncidentProcess("someProcess"));
        this.waitUntilIncidentRecordWithProcessIdExported("someProcess");
        this.importAllZeebeEntitiesFromScratch();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{savedInstance -> ((ListAssert)((ListAssert)Assertions.assertThat((List)savedInstance.getIncidents()).isNotEmpty()).hasSize(1)).containsExactly((Object[])new IncidentDto[]{this.createIncident((ProcessInstanceDto)savedInstance, deployedInstance, "catchEvent", IncidentStatus.OPEN)})});
    }

    @Test
    public void importZeebeIncidentData_importResolvedIncidentInSameBatch() {
        ProcessInstanceEvent deployedInstance = this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createSimpleServiceTaskProcess("someProcess"));
        zeebeExtension.throwErrorIncident("service_task");
        this.waitUntilIncidentRecordWithProcessIdExported("someProcess");
        this.resolveIncident();
        this.waitUntilIncidentRecordsWithProcessIdExported(2L, "someProcess");
        this.importAllZeebeEntitiesFromScratch();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{savedInstance -> ((ListAssert)Assertions.assertThat((List)savedInstance.getIncidents()).isNotEmpty()).containsExactly((Object[])new IncidentDto[]{this.createIncident((ProcessInstanceDto)savedInstance, deployedInstance, "service_task", IncidentStatus.RESOLVED)})});
    }

    @Test
    public void importZeebeIncidentData_importResolvedIncidentInDifferentBatches() {
        ProcessInstanceEvent deployedInstance = this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createSimpleServiceTaskProcess("someProcess"));
        zeebeExtension.throwErrorIncident("service_task");
        this.waitUntilIncidentRecordWithProcessIdExported("someProcess");
        this.importAllZeebeEntitiesFromScratch();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{savedInstance -> ((ListAssert)Assertions.assertThat((List)savedInstance.getIncidents()).isNotEmpty()).containsExactly((Object[])new IncidentDto[]{this.createIncident((ProcessInstanceDto)savedInstance, deployedInstance, "service_task", IncidentStatus.OPEN)})});
        this.resolveIncident();
        this.waitUntilIncidentRecordsWithProcessIdExported(2L, "someProcess");
        this.importAllZeebeEntitiesFromLastIndex();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{savedInstance -> ((ListAssert)Assertions.assertThat((List)savedInstance.getIncidents()).isNotEmpty()).containsExactly((Object[])new IncidentDto[]{this.createIncident((ProcessInstanceDto)savedInstance, deployedInstance, "service_task", IncidentStatus.RESOLVED)})});
    }

    @DisabledIf(value="isZeebeVersionWithMultiTenancy")
    @Test
    public void importZeebeIncidentData_defaultTenantIdForRecordsWithoutTenantId() {
        this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createSimpleServiceTaskProcess("someProcess"));
        zeebeExtension.failTask("service_task");
        this.waitUntilIncidentRecordWithProcessIdExported("someProcess");
        this.importAllZeebeEntitiesFromScratch();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).flatExtracting(ProcessInstanceDto::getIncidents).extracting(IncidentDto::getTenantId).singleElement()).isEqualTo((Object)"<default>");
    }

    @EnabledIf(value="isZeebeVersionWithMultiTenancy")
    @Test
    public void importZeebeIncidentData_tenantIdImported() {
        this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createSimpleServiceTaskProcess("aProcess"));
        zeebeExtension.failTask("service_task");
        this.waitUntilIncidentRecordsWithProcessIdExported(1L, "aProcess");
        String expectedTenantId = "testTenant";
        this.setTenantIdForExportedZeebeRecords("incident", "testTenant");
        this.importAllZeebeEntitiesFromScratch();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).flatExtracting(ProcessInstanceDto::getIncidents).extracting(IncidentDto::getTenantId).singleElement()).isEqualTo((Object)"testTenant");
    }

    private void waitUntilIncidentRecordWithProcessIdExported(String processId) {
        this.waitUntilIncidentRecordsWithProcessIdExported(1L, processId);
    }

    private TermsQueryContainer getQueryForIncidentEvents() {
        TermsQueryContainer query = new TermsQueryContainer();
        query.addTermQuery("intent", List.of(IncidentIntent.CREATED.name(), IncidentIntent.RESOLVED.name()));
        return query;
    }

    private IncidentDto createIncident(ProcessInstanceDto processInstanceDto, ProcessInstanceEvent deployedInstance, String activityId, IncidentStatus incidentStatus) {
        Map<IncidentIntent, List<ZeebeIncidentRecordDto>> incidentsForRecordByIntent = this.getZeebeExportedIncidentEventsByElementId().entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).collect(Collectors.groupingBy(ZeebeRecordDto::getIntent));
        ZeebeIncidentRecordDto createdRecord = incidentsForRecordByIntent.get(IncidentIntent.CREATED).get(0);
        ZeebeIncidentRecordDto resolvedRecord = Optional.ofNullable(incidentsForRecordByIntent.get(IncidentIntent.RESOLVED)).map(incidentRecords -> (ZeebeIncidentRecordDto)incidentRecords.get(0)).orElse(null);
        IncidentDto incident = new IncidentDto();
        incident.setId(String.valueOf(createdRecord.getKey()));
        incident.setDefinitionKey(deployedInstance.getBpmnProcessId());
        incident.setDefinitionVersion(String.valueOf(deployedInstance.getVersion()));
        incident.setTenantId("<default>");
        incident.setProcessInstanceId(null);
        incident.setActivityId(String.valueOf(this.getFlowNodeIdFromProcessInstanceForActivity(processInstanceDto, activityId)));
        incident.setIncidentType(IncidentType.valueOfId((String)((ZeebeIncidentDataDto)createdRecord.getValue()).getErrorType().toString()));
        incident.setIncidentMessage(((ZeebeIncidentDataDto)createdRecord.getValue()).getErrorMessage());
        incident.setIncidentStatus(incidentStatus);
        OffsetDateTime createTime = OffsetDateTime.ofInstant(Instant.ofEpochMilli(createdRecord.getTimestamp()), ZoneId.systemDefault());
        incident.setCreateTime(createTime);
        OffsetDateTime endTime = Optional.ofNullable(resolvedRecord).map(record -> OffsetDateTime.ofInstant(Instant.ofEpochMilli(record.getTimestamp()), ZoneId.systemDefault())).orElse(null);
        incident.setEndTime(endTime);
        Optional.ofNullable(endTime).ifPresent(end -> incident.setDurationInMs(Long.valueOf(createTime.until((Temporal)end, ChronoUnit.MILLIS))));
        return incident;
    }

    private Map<Long, List<ZeebeIncidentRecordDto>> getZeebeExportedIncidentEventsByElementId() {
        String expectedIndex = zeebeExtension.getZeebeRecordPrefix() + "-incident";
        return databaseIntegrationTestExtension.getZeebeExportedRecordsByQuery(expectedIndex, this.getQueryForIncidentEvents(), ZeebeIncidentRecordDto.class).stream().collect(Collectors.groupingBy(event -> ((ZeebeIncidentDataDto)event.getValue()).getElementInstanceKey()));
    }

    private void resolveIncident() {
        ZeebeIncidentRecordDto exportedIncident = (ZeebeIncidentRecordDto)this.getZeebeExportedIncidentEventsByElementId().values().stream().flatMap(Collection::stream).findFirst().orElseThrow(() -> new OptimizeIntegrationTestException("Cannot find any exported incidents"));
        zeebeExtension.resolveIncident(exportedIncident.getKey());
    }

    private String getFlowNodeIdFromProcessInstanceForActivity(ProcessInstanceDto processInstanceDto, String activityId) {
        return this.getPropertyIdFromProcessInstanceForActivity(processInstanceDto, activityId, FlowNodeInstanceDto::getFlowNodeId);
    }

    private void waitUntilIncidentRecordsWithProcessIdExported(long minRecordCount, String processId) {
        TermsQueryContainer query = new TermsQueryContainer();
        query.addTermQuery("value.bpmnProcessId", processId);
        this.waitUntilRecordMatchingQueryExported(minRecordCount, "incident", query);
    }
}

